/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "common/Event.h"
#include "Logger/LoggerMacroses.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/ChangePasswordCommand.h"
#include "treemanager/TreeManagerUtils.h"
#include "serverexchange/IServerExchangeManager.h"


using namespace NS_DM_Client;
const char* const c_LogName = "ChangePasswordCommand";


ChangePasswordCommand::ChangePasswordCommand(ProfileComponentsHolder &pch,
											 const String &oldPassword, const String &newPassword, 
											 NS_Common::EventEx &executionCompleted, bool& executionResult)
	: DMAccountCommand(pch),
	m_oldPassword(oldPassword), m_newPassword(newPassword), m_result(executionResult), m_event(executionCompleted)
{
}


bool ChangePasswordCommand::Execute()
{
	m_result = false;

	String accountSrvID;
	m_pch.GetServerExchangeManager()->DefaultConnectionName(accountSrvID);
	if (!accountSrvID.empty())
	{
		m_accountSrvID = accountSrvID.c_str();
		FStringBuffer uriAccount;
		getDMAccountURI(uriAccount);
		
		if (!uriAccount.empty())
			m_result = changeClientCredPass(uriAccount);
	}
	m_event.signal();

	return true;
}


void ChangePasswordCommand::getDMAccountURI(FStringBuffer &uri)
{
	if (m_accountSrvID.empty()) return;

	IMOTreeManager::ChildrenPaths accounts;
	FStringBuffer uriDMAcc(URI_DMACC);
	if (TMUtils::IsDMAccNode(m_treeManager, URI_DMACC) && isAccountWithServerID(uriDMAcc, m_accountSrvID))
	{
		uri =  URI_DMACC;
	}
	else if (e_Ok == m_pch.GetMOTreeManager()->GetChildren(URI_DMACC, accounts, ""))
	{
		for (size_t i=0; i<accounts.size(); ++i)
		{
			String &accname = accounts[i];
			FStringBuffer uriAccount0(URI_DMACC);
			uriAccount0.append("/").append(accname.c_str()); // this is uri ./DMAcc/X
			if (TMUtils::IsDMAccNode(m_treeManager, uriAccount0.c_str()) && isAccountWithServerID(uriAccount0, m_accountSrvID))
				uri = uriAccount0;
		}
	}
}


bool ChangePasswordCommand::isAccountWithServerID(FStringBuffer &uriAccount, FStringBuffer &serverID)
{
	FStringBuffer outvalue;
	return getLeafValue(uriAccount, "ServerID",  outvalue) && (serverID == outvalue);
}


bool ChangePasswordCommand::changeClientCredPass(FStringBuffer &uriAccount)
{
	FStringBuffer clCredAddr;
	if (getAuthenticationNode(uriAccount, clCredAddr, CLCRED))
	{
		FStringBuffer password;
		if (getLeafValue(clCredAddr, "AAuthSecret", password))
		{
			if (m_oldPassword == password.c_str())
			{
				FStringBuffer newpass(m_newPassword.c_str());
				return setLeafValue(clCredAddr, "AAuthSecret", newpass);
			}
		}
	}
	return false;
}

