#pragma inline_depth(255)
#include "agh.h"
#include <time.h>


using namespace agh;

#define INSTANCE_COUNT		(100000)
#define CPU_CLOCK_MHZ		(3000)

#define PRINT_SPEED			\
	printf(" %d ms (1per %f us, %d clock)\n",	\
		clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0,	\
		(clock() - prev_clock) * (CPU_CLOCK_MHZ *1000 / INSTANCE_COUNT) );
#define PRINT_SPEED2(X)		\
	printf(" %d ms (1per %f us, %d clock)\n",	\
		clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0 /X,	\
		(int)((clock() - prev_clock) * (CPU_CLOCK_MHZ *1000.0f / INSTANCE_COUNT/X )) );

int main()
{
	int prev_clock = clock();
	printf("start.\n");
	int i, j;

	printf("\n== Instance Size =================================\n");
	printf("CControlBase: %d byte.\n", sizeof(agh::CControlBase));
	printf("CVisualControlBase: %d byte.\n", sizeof(agh::CVisualControlBase));
	printf("CImageBase: %d byte.\n", sizeof(agh::CImageBase));
	printf("CTextBase: %d byte.\n", sizeof(agh::CTextBase));
	printf("CWindowBase: %d byte.\n", sizeof(agh::CWindowBase));
	printf("CEffectControlBase: %d byte.\n", sizeof(agh::CEffectControlBase));

	printf("\n== Speed Test =================================\n");

	//==============================================================

	printf("\n//  New Instance\n");

	CControlBase *cbl[INSTANCE_COUNT];
	printf("Now Time: %d\n", prev_clock = clock());

	//	mov
	printf("mov (%d Loops) :", INSTANCE_COUNT*1000);
	for(i=0; i<INSTANCE_COUNT; i++)
		for(j=0; j<1000; j++)
			cbl[i] = (CControlBase*) j;
	printf(" %d ms (1per %f us, %d clock)\n",	\
		clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0,	\
		(int)((clock() - prev_clock) * (CPU_CLOCK_MHZ / (double)INSTANCE_COUNT)) );

	//	int
	prev_clock = clock();
	printf("int New Instance (%d Loops) :", INSTANCE_COUNT);
	for(i=0; i<INSTANCE_COUNT; i++)
		cbl[i] = (CControlBase*) new int;
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED

	//	int[sizeof(agh::CControlBase)]
	printf("int[%d] New Instance (%d Loops) :", sizeof(agh::CControlBase), INSTANCE_COUNT);
	for(i=0; i<INSTANCE_COUNT; i++)
		cbl[i] = (CControlBase*) new int[sizeof(agh::CControlBase)];
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED

	//	int[sizeof(agh::CVisualControlBase)]
	printf("int[%d] New Instance (%d Loops) :", sizeof(agh::CVisualControlBase), INSTANCE_COUNT);
	for(i=0; i<INSTANCE_COUNT; i++)
		cbl[i] = (CControlBase*) new int[sizeof(agh::CVisualControlBase)];
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED

	//	CControlBase
	printf("CControlBase New Instance (%d Loops) :", INSTANCE_COUNT);
	for(i=0; i<INSTANCE_COUNT; i++)
		cbl[i] = new CControlBase();
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED

	//	CVisualControlBase
	CVisualControlBase *vcbl[INSTANCE_COUNT];
	prev_clock = clock();
	printf("CVisualControlBase New Instance (%d Loops) :", INSTANCE_COUNT);
	for(i=0; i<INSTANCE_COUNT; i++)
		vcbl[i] = new CVisualControlBase();
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED
	prev_clock = clock();

	//==============================================================

	printf("\n//  RegistChild\n");

	//	CControlBase
	prev_clock = clock();
	printf("CControlBase Regist Sub Control (%d Loops) :", INSTANCE_COUNT);
	for(i=1; i<INSTANCE_COUNT; i++)
		cbl[0]->RegistChild( cbl[i] );
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED
	prev_clock = clock();

	//	CVisualControlBase
	prev_clock = clock();
	printf("CVisualControlBase Regist Sub Control (%d Loops) :", INSTANCE_COUNT*10);
	for(i=10; i<INSTANCE_COUNT*10; i++)
		vcbl[i%10]->RegistChild( vcbl[i/10] );
	//printf(" %d ms (1per %f us)\n", clock() - prev_clock, (double)(clock() - prev_clock) / INSTANCE_COUNT * 1000.0);
	PRINT_SPEED
	prev_clock = clock();

	//==============================================================

	printf("\n//  iterator\n");

	//	CControlBase
	prev_clock = clock();
	printf("CControlBase iterator (%d Loops) :", INSTANCE_COUNT*100);
	for(j=0; j<10*100; j++){
		for(CControlBase::ctrl_iterator it = cbl[j%10]->cbegin(); it != cbl[j%10]->cend(); it++)
			it->GetInternal();
	}
	PRINT_SPEED2(100)
	prev_clock = clock();

	//	CVisualControlBase
	prev_clock = clock();
	printf("CVisualControlBase iterator (%d Loops) :", INSTANCE_COUNT*10);
	for(j=0; j<10*10; j++){
		for(CControlBase::vctrl_iterator it = vcbl[j%10]->vcbegin(); it != vcbl[j%10]->vcend(); it++)
			;
	}
	PRINT_SPEED2(100)
	prev_clock = clock();

	//==============================================================

	printf("\n");

	return 0;
}
