#include "mglaugust2.h"

//	Ct[NX
class CMyFrame : public CAugustWindowFrame2
{
private:
	CAugustImage2 m_img;
	CAugustText2 m_text;
	CAugustMouseInput m_mouse;

	bool m_bFlg;
public:

	//	ɌĂ΂
	bool OnGraphicInitEnded()
	{
		//m_fps.SetFps(1);
		//	Rg[NX̓o^
		RegistControl(&m_img);
		RegistControl(&m_text);
		RegistControl(&m_mouse);

		//	摜̓ǂݍ
		m_img.Load("test.jpg");

		//	}EXNbNnh̓o^
		m_mouse.RegistHandler(
			CAugustMouseInput::EVTTYPE_ON_DOWN,
			CAugustMouseInput::LBUTTON,
			(CAugustMouseInput::CALLBACK_TYPE_MI)&CMyFrame::OnMouseLDown,
			this);
		m_mouse.RegistHandler(
			CAugustMouseInput::EVTTYPE_ON_UP,
			CAugustMouseInput::LBUTTON,
			(CAugustMouseInput::CALLBACK_TYPE_MI)&CMyFrame::OnMouseLUp,
			this);

		//	}EXړnh̓o^
		m_mouse.RegistHandler(
			CAugustMouseInput::EVTTYPE_ON_MOVE,
			0,
			(CAugustMouseInput::CALLBACK_TYPE_MI)&CMyFrame::OnMouseMove,
			this);

		//	}EXzC[nh̓o^
		m_mouse.RegistHandler(
			CAugustMouseInput::EVTTYPE_ON_MOVE,
			CAugustMouseInput::CBUTTON,
			(CAugustMouseInput::CALLBACK_TYPE_MI)&CMyFrame::OnMouseZoom,
			this);

		m_bFlg = false;

		return true;
	}

	//	NbNɌĂ΂
	bool OnMouseLDown(int x, int y){
		char msg[256];
		sprintf(msg, "(%d, %d) NbN܂B", x, y);
		//::MessageBoxA(NULL,msg,"OnLButtonDown",NULL);
		m_bFlg = true;
		return true;
	}

	//	NbNɌĂ΂
	bool OnMouseLUp(int x, int y){
		m_bFlg = false;
		return true;
	}

	//	}EXړɌĂ΂
	bool OnMouseMove(int x, int y){
		char msg[256];
		sprintf(msg, "(%d, %d)", x, y);
		m_text.SetText(msg);

		if ( !m_bFlg )
			m_img.Move(x,y);
		return true;
	}

	//	}EXzC[ɌĂ΂
	bool OnMouseZoom(int x, int y){
		m_img.SetScale(m_img.GetScale()+(x/500.0f));
		return true;
	}
};

//	WinMain
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
	CMyFrame frame;
	frame.Start();
	return 0;
}
