//////////////////////////////////////////////////////////
//
//	Myu2DGraphicsSurface
//		- MglGraphicManager T[tFXNX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Myu2DGraphicsSurface.h"

//	RXgN^
CMyu2DGraphicsSurface::CMyu2DGraphicsSurface()
{
	m_nSfcID = g_nSfcCount;
	g_nSfcCount++;
	//_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::CMyu2DGraphicsSurface( ID : %d )", g_nSfcCount );

	m_myudg = NULL;
	m_pTexture = NULL;
	m_pSurface = NULL;
	m_pSprite = NULL;
	d3d = NULL;

	//	tO
	initFlg = FALSE;
	createFlg = FALSE;
	m_bCenterDraw = FALSE;
}

//	fXgN^
CMyu2DGraphicsSurface::~CMyu2DGraphicsSurface()
{
	//_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::~CMyu2DGraphicsSurface( ID : %d )", m_nSfcID );
//	_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::fXgN^" );
	Release();
//	_MGL_DEBUGLOG( "- CMyu2DGraphicsSurface::fXgN^" );
}


//	
void CMyu2DGraphicsSurface::Init( CMglGraphicManager* in_myudg, const char* szName )
{
	//_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::Init()" );

	m_myudg = in_myudg;
	d3d = m_myudg->GetD3dDevPtr();
	m_colorKey = D3DCOLOR_BLACK;
	if ( szName != NULL )
		m_sfcName = szName;

	//	JpɃt@Xǉ
	m_myudg->AddRefOfAutoRelease( this );

	initFlg = TRUE;
	//_MGL_DEBUGLOG( "- CMyu2DGraphicsSurface::Init()" );
}

//	IJ
void CMyu2DGraphicsSurface::Release()
{
//	_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::Release()" );

	//	Jp̃t@X폜
	DELREF();

	SAFE_RELEASE( m_pSurface );
	SAFE_RELEASE( m_pTexture );
//	SAFE_RELEASE( m_pSprite );
//	_MGL_DEBUGLOG( "- CMyu2DGraphicsSurface::Release()" );
}

//	t@Cǂݍ
//	J[L[̓At@gp̂Ƃ̂ݗL
//	J[L[gpȂꍇcolorKey0
//	J[L[Lɂꍇ0xff******ɂ
void CMyu2DGraphicsSurface::CreateFromFile( LPCSTR szFileName, BOOL bRenderTarget, D3DCOLOR colorKey )
{
	_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::CreateFromFile( \"%s\", %d, 0x%08X )", szFileName, bRenderTarget, colorKey );

	InitCheck();	//	`FbN

	//	ڈȍ~̌Ăяol[Release
	Release();

	//////////////////////////////////////////////////////////////////////////////
	//
	//	D3DXGetImageInfoFromFile()̂ŖTCY擾łBق(LD`)
	//

	IDirect3DTexture8* m_pTexture2;	//	eNX`
	D3DXIMAGE_INFO imgInfo;

	MyuAssert( D3DXCreateTextureFromFileEx( d3d, szFileName, 256, 256, D3DX_DEFAULT,
		0, /* m_myudg->backBufferDesc.Format */ m_myudg->GetFormat(), D3DPOOL_SYSTEMMEM,
		D3DX_FILTER_POINT, D3DX_FILTER_POINT, colorKey, &imgInfo, NULL, &m_pTexture2 ),
		D3D_OK, "CMyu2DGraphicsSurface::CreateFromFile()  %s ̃C[W擾ɎsB", szFileName );

	int x = imgInfo.Width;
	int y = imgInfo.Height;

	SAFE_RELEASE( m_pTexture2 );

	///////////////////////////////////////////////////////////////////
	//
	//	eNX`쐬
	//
	//	D3DXCreateTextureFromFileEx()ɂč쐬sA
	//	͂܂ŃJ[L[ݒ肷邽߂B
	//	ȂA摜͈L΂Ĉ܂̂ŁAXēǂݍ݂
	//

	if ( bRenderTarget == TRUE ) {
		DWORD r = D3DXCreateTextureFromFileEx( d3d, szFileName, x, y, D3DX_DEFAULT,
			D3DUSAGE_RENDERTARGET, /* m_myudg->backBufferDesc.Format */ m_myudg->GetFormat(), D3DPOOL_DEFAULT,
			D3DX_FILTER_POINT, D3DX_FILTER_POINT, colorKey, &imgInfo, NULL, &m_pTexture );

		if ( r == E_OUTOFMEMORY )
			MyuThrow2( r, 0x0201, "%s ̓ǂݍ݂ɎsBVRAM܂̓sĂ܂B", szFileName );
		else if ( r == D3DERR_OUTOFVIDEOMEMORY )
			MyuThrow2( r, 0x0202, "%s ̓ǂݍ݂ɎsBVRAMsĂ܂B", szFileName );
		else if ( r != S_OK ) 
			MyuThrow2( r, 0x0203, "CMyu2DGraphicsSurface::CreateFromFile()  D3DXCreateTextureFromFileEx(VRAM,%s)Ɏs", szFileName );
	}
	else {
		DWORD r = D3DXCreateTextureFromFileEx( d3d, szFileName, x, y, D3DX_DEFAULT,
			0, /* m_myudg->backBufferDesc.Format */ m_myudg->GetFormat(), D3DPOOL_MANAGED,
			D3DX_FILTER_POINT, D3DX_FILTER_POINT, colorKey, &imgInfo, NULL, &m_pTexture );

		if ( r == E_OUTOFMEMORY )
			MyuThrow( r, "%s ̓ǂݍ݂ɎsB܂B", szFileName );
		else if ( r != S_OK ) 
			MyuThrow( r, "CMyu2DGraphicsSurface::CreateFromFile()  D3DXCreateTextureFromFileEx(MANAGED,%s)Ɏs", szFileName );
	}

	m_nBmpSizeX = x;
	m_nBmpSizeY = y;

	int i;
	ZeroMemory( m_vertices, sizeof(MYU_VERTEX)*4 );

	//	TCYZo(GetRealTexSizeg@邪AꉞeNX`Ă)
	D3DSURFACE_DESC texDesc;
	m_pTexture->GetLevelDesc( 0, &texDesc );
	nRealSizeX = texDesc.Width;
	nRealSizeY = texDesc.Height;

	//	䗦ݒ
	fRealTexTu = (float)x / (float)nRealSizeX;
	fRealTexTv = (float)y / (float)nRealSizeY;

	//	ƂvꉞftHglƂēĂc
	//	X,Y܂
	m_vertices[VERTEXNO_LT].x = m_vertices[VERTEXNO_LB].x = 0+X_ADJ;
	m_vertices[VERTEXNO_LT].y = m_vertices[VERTEXNO_RT].y = 0+Y_ADJ;
	m_vertices[VERTEXNO_RB].x = m_vertices[VERTEXNO_RT].x = x+X_ADJ;
	m_vertices[VERTEXNO_RB].y = m_vertices[VERTEXNO_LB].y = y+Y_ADJ;

	//	U,V
	m_vertices[VERTEXNO_LT].tu = m_vertices[VERTEXNO_LB].tu = 0.0f;
	m_vertices[VERTEXNO_LT].tv = m_vertices[VERTEXNO_RT].tv = 0.0f;
	//m_vertices[VERTEXNO_RB].tu = m_vertices[VERTEXNO_RT].tu = 1.0f;
	//m_vertices[VERTEXNO_RB].tv = m_vertices[VERTEXNO_LB].tv = 1.0f;
	m_vertices[VERTEXNO_RT].tu = m_vertices[VERTEXNO_RB].tu = fRealTexTu;
	m_vertices[VERTEXNO_LB].tv = m_vertices[VERTEXNO_RB].tv = fRealTexTv;


	//	̑
	for ( i=0; i<4; i++ )
	{
		m_vertices[i].z = 0.0f;
		m_vertices[i].rhw = 1.0f;
		m_vertices[i].color = 0xffffffff;
	}
	//SetGradation();

	//	eNX`̃T[tFX擾
	MyuAssert( m_pTexture->GetSurfaceLevel(0, &m_pSurface), D3D_OK,
		"CMyu2DGraphicsSurface::Create()  GetSurfaceLevel()Ɏs" );

	m_colorKey = colorKey;
	if ( m_colorKey != 0 )	//	J[L[gpꍇ0xffÔ߂Ă
		m_colorKey |= 0xff000000;

	//	XvCg쐬
	MyuAssert( D3DXCreateSprite( d3d, &this->m_pSprite ), D3D_OK,
		"CMyu2DGraphicsSurface::Init  D3DXCreateSprite()Ɏs" );

	/////////////////////////////////////////////////////////////////////////
	//
	//	C[Wēǂݍ݂
	//

	IDirect3DSurface8* m_pTempSurface;	//	ꎞT[tFX
	MyuAssert( d3d->CreateImageSurface( x, y, m_myudg->GetFormat(), &m_pTempSurface ),
		D3D_OK, "CMyu2DGraphicsSurface::CreateFromFile()  CreateImageSurface()Ɏs" );

	MyuAssert( D3DXLoadSurfaceFromFile( m_pTempSurface, NULL, NULL, szFileName, NULL, D3DX_FILTER_POINT, 0xffff00ff, NULL ),
		D3D_OK, "CMyu2DGraphicsSurface::CreateFromFile()  D3DXLoadSurfaceFromFile()Ɏs" );

	//MyuAssert( d3d->CopyRects(m_pTempSurface, NULL, 0, m_pSurface, NULL),
	MyuAssert( d3d->CopyRects(m_pTempSurface, NULL, 0, m_pSurface, NULL),
		D3D_OK, "CMyu2DGraphicsSurface::CreateFromFile()  CopyRects()Ɏs" );

	SAFE_RELEASE( m_pTempSurface );

	m_bRenderTarget = bRenderTarget;
	createFlg = TRUE;

	_MGL_DEBUGLOG( "- CMyu2DGraphicsSurface::CreateFromFile( \"%s\" )", szFileName );
}

//	T[tFCX̐
void CMyu2DGraphicsSurface::Create( int x, int y, BOOL bRenderTarget )
{
	_MGL_DEBUGLOG( "+ CMyu2DGraphicsSurface::Create()" );

	InitCheck();	//	`FbN

	if ( x == 0 )	x = m_myudg->GetDispX();
	if ( y == 0 )	y = m_myudg->GetDispY();
	m_nBmpSizeX = x;
	m_nBmpSizeY = y;

	int i;
	ZeroMemory( m_vertices, sizeof(MYU_VERTEX)*4 );

	//	m_myudg->backBufferDesc.Format
	if ( bRenderTarget == TRUE ) {
		MyuAssert( D3DXCreateTexture( d3d, x, y, D3DX_DEFAULT, D3DUSAGE_RENDERTARGET, m_myudg->GetFormat(), D3DPOOL_DEFAULT, &m_pTexture ), D3D_OK,
			"CMyu2DGraphicsSurface::Create()  D3DXCreateTexture(VRAM)Ɏs" );
	}
	else {
		MyuAssert( D3DXCreateTexture( d3d, x, y, D3DX_DEFAULT, 0, m_myudg->GetFormat(), D3DPOOL_MANAGED, &m_pTexture ), D3D_OK,
			"CMyu2DGraphicsSurface::Create()  D3DXCreateTexture(SYSMEM)Ɏs" );
	}

	//	TCYZo(GetRealTexSizeg@邪AꉞeNX`Ă)
	D3DSURFACE_DESC texDesc;
	m_pTexture->GetLevelDesc( 0, &texDesc );
	nRealSizeX = texDesc.Width;
	nRealSizeY = texDesc.Height;

	//	䗦ݒ
	fRealTexTu = (float)x / (float)nRealSizeX;
	fRealTexTv = (float)y / (float)nRealSizeY;

	//	ƂvꉞftHglƂēĂc
	//	X,Y܂
	m_vertices[VERTEXNO_LT].x = m_vertices[VERTEXNO_LB].x = 0+X_ADJ;
	m_vertices[VERTEXNO_LT].y = m_vertices[VERTEXNO_RT].y = 0+Y_ADJ;
	m_vertices[VERTEXNO_RB].x = m_vertices[VERTEXNO_RT].x = x+X_ADJ;
	m_vertices[VERTEXNO_RB].y = m_vertices[VERTEXNO_LB].y = y+Y_ADJ;

	//	U,V
	m_vertices[VERTEXNO_LT].tu = m_vertices[VERTEXNO_LB].tu = 0.0f;
	m_vertices[VERTEXNO_LT].tv = m_vertices[VERTEXNO_RT].tv = 0.0f;
	//m_vertices[VERTEXNO_RB].tu = m_vertices[VERTEXNO_RT].tu = 1.0f;
	//m_vertices[VERTEXNO_RB].tv = m_vertices[VERTEXNO_LB].tv = 1.0f;
	m_vertices[VERTEXNO_RT].tu = m_vertices[VERTEXNO_RB].tu = fRealTexTu;
	m_vertices[VERTEXNO_LB].tv = m_vertices[VERTEXNO_RB].tv = fRealTexTv;

	//	̑
	for ( i=0; i<4; i++ )
	{
		m_vertices[i].z = 0.0f;
		m_vertices[i].rhw = 1.0f;
		m_vertices[i].color = 0xffffffff;
	}
	//SetGradation();

	//	eNX`̃T[tFX擾
	MyuAssert( m_pTexture->GetSurfaceLevel(0, &m_pSurface), D3D_OK,
		"CMyu2DGraphicsSurface::Create()  GetSurfaceLevel()Ɏs" );

	//	XvCg쐬
	MyuAssert( D3DXCreateSprite( d3d, &this->m_pSprite ), D3D_OK,
		"CMyu2DGraphicsSurface::Init  D3DXCreateSprite()Ɏs" );

	//	NA
	//Clear();

	m_bRenderTarget = bRenderTarget;

	createFlg = TRUE;

	_MGL_DEBUGLOG( "- CMyu2DGraphicsSurface::Create()" );
}


//void DrawEx( float fScaleX, float fScaleY, float fRotationCenterX, float fRotationCenterY, float fAngle,
//	float x, float y, RECT *srcRect=NULL, D3DCOLOR color=0xffffffff, DWORD dwAlphaOption=MGL_ALPHA_OPT_NOCHANGE );

//	Texture(DrawPrimitiveUP)ŊG
void CMyu2DGraphicsSurface::TextureDraw(
	float x, float y, RECT* srcRect, float fScaleX, float fScaleY,
	float fRotationCenterX, float fRotationCenterY, float fAngle,
	VERTEX_COLORS* vertexColors, DWORD dwAlphaOption )
{
	CreateCheck();	//	Create`FbN

	//	srcRectlBMPTCY
	int nBmpSrcX = m_nBmpSizeX;
	int nBmpSrcY = m_nBmpSizeY;

	//	]ǂ̐ݒ
	if ( srcRect == NULL )
	{
		m_vertices[VERTEXNO_LT].tu = m_vertices[VERTEXNO_LB].tu = 0.0f;
		m_vertices[VERTEXNO_LT].tv = m_vertices[VERTEXNO_RT].tv = 0.0f;
		//m_vertices[VERTEXNO_RB].tu = m_vertices[VERTEXNO_RT].tu = 1.0f;
		//m_vertices[VERTEXNO_RB].tv = m_vertices[VERTEXNO_LB].tv = 1.0f;
		m_vertices[VERTEXNO_RT].tu = m_vertices[VERTEXNO_RB].tu = fRealTexTu;
		m_vertices[VERTEXNO_LB].tv = m_vertices[VERTEXNO_RB].tv = fRealTexTv;
	}
	else
	{
		float fLeftTu = ((float)srcRect->left / m_nBmpSizeX) * fRealTexTu;
		float fRightTu = ((float)srcRect->right / m_nBmpSizeX) * fRealTexTu;
		float fTopTv = ((float)srcRect->top / m_nBmpSizeY) * fRealTexTv;
		float fBottomTv = ((float)srcRect->bottom / m_nBmpSizeY) * fRealTexTv;

		/*
		m_vertices[VERTEXNO_LT].tu = m_vertices[VERTEXNO_LB].tu = fLeftTu;
		m_vertices[VERTEXNO_RT].tu = m_vertices[VERTEXNO_RB].tu = fRightTu;
		m_vertices[VERTEXNO_LT].tv = m_vertices[VERTEXNO_RT].tv = fTopTv;
		m_vertices[VERTEXNO_LB].tv = m_vertices[VERTEXNO_RB].tv = fBottomTv;
		*/
		m_vertices[VERTEXNO_LT].tu = m_vertices[VERTEXNO_LB].tu = fLeftTu;
		m_vertices[VERTEXNO_RT].tu = m_vertices[VERTEXNO_RB].tu = fRightTu;
		m_vertices[VERTEXNO_LT].tv = m_vertices[VERTEXNO_RT].tv = fTopTv;
		m_vertices[VERTEXNO_LB].tv = m_vertices[VERTEXNO_RB].tv = fBottomTv;

		nBmpSrcX = srcRect->right - srcRect->left;
		nBmpSrcY = srcRect->bottom - srcRect->top;
	}
	//	S_G@\
	if ( m_bCenterDraw == TRUE )
	{
		int nSizeX = srcRect->right - srcRect->left;
		int nSizeY = srcRect->bottom - srcRect->top;
		x -= (nSizeX/2) * fScaleX;
		y -= (nSizeY/2) * fScaleY;
	}

	//	GʒuAyѐLk̐ݒ
	m_vertices[VERTEXNO_LT].x = m_vertices[VERTEXNO_LB].x = x + X_ADJ;	//	GʒuX
	m_vertices[VERTEXNO_LT].y = m_vertices[VERTEXNO_RT].y = y + Y_ADJ;	//	GʒuY
	m_vertices[VERTEXNO_RB].x = m_vertices[VERTEXNO_RT].x = x + X_ADJ + nBmpSrcX * fScaleX;	//	LkX
	m_vertices[VERTEXNO_RB].y = m_vertices[VERTEXNO_LB].y = y + Y_ADJ + nBmpSrcY * fScaleY;	//	LkY

	//	F
	m_vertices[VERTEXNO_LT].color = vertexColors->leftTop;
	m_vertices[VERTEXNO_RT].color = vertexColors->rightTop;
	m_vertices[VERTEXNO_LB].color = vertexColors->leftBottom;
	m_vertices[VERTEXNO_RB].color = vertexColors->rightBottom;

	//	At@IvV
	m_myudg->SetAlphaMode( dwAlphaOption );

	//	G
	TextureDrawPrimitive();
}


void CMyu2DGraphicsSurface::TextureDrawPrimitive()
{
	CreateCheck();	//	Create`FbN

	//	eNX`̐ݒ
	MyuAssert( d3d->SetTexture(0, m_pTexture), D3D_OK,
		"CMyu2DGraphicsSurface::TextureDrawPrimitive()  SetTexture()Ɏs" );

	//	G
	MyuAssert( d3d->DrawPrimitiveUP( D3DPT_TRIANGLEFAN, 2, m_vertices, sizeof(MYU_VERTEX) ), D3D_OK,
		"CMyu2DGraphicsSurface::TextureDrawPrimitive()  DrawPrimitiveUP()Ɏs" );
}


//	]EXP[OEAt@IvVtGiXvCggpj
void CMyu2DGraphicsSurface::DrawEx(
	float fScaleX, float fScaleY, float fRotationCenterX, float fRotationCenterY, float fAngle,
	float x, float y, RECT *srcRect, D3DCOLOR color )
//	float x, float y, RECT *srcRect, D3DCOLOR color, DWORD dwAlphaOption )
{
	CreateCheck();	//	Create`FbN

	//	srcRectNULLw肳ꂽꍇ̓tŊG
	RECT _srcRect;
	if ( srcRect == NULL )
	{
		srcRect = &_srcRect;
		_Rect( 0, 0, m_nBmpSizeX, m_nBmpSizeY, srcRect );
	}

	//	S_G@\
	if ( m_bCenterDraw == TRUE )
	{
		int nSizeX = srcRect->right - srcRect->left;
		int nSizeY = srcRect->bottom - srcRect->top;
		x -= (nSizeX/2) * fScaleX;
		y -= (nSizeY/2) * fScaleY;
	}

	//	x, yD3DXVECTOR2\̂Ɋi[
	D3DXVECTOR2 vctPos;
	vctPos.x = x;
	vctPos.y = y;

	//	XP[
	D3DXVECTOR2 vctScale;
	vctScale.x = fScaleX;
	vctScale.y = fScaleY;

	//	]̒S
	D3DXVECTOR2 vctRtCenter;
	vctRtCenter.x = (srcRect->right - srcRect->left) * fRotationCenterX * fScaleX;
	vctRtCenter.y = (srcRect->bottom - srcRect->top) * fRotationCenterY * fScaleY;

	/*	XvCg̓At@IvVȂۂ
	//	At@IvV
	DWORD dwAlphaOptionBkup=0;
	if ( dwAlphaOption != MGL_ALPHA_OPT_NOCHANGE )
	{
		//	߂̂߂ɃobNAbvĂ
		dwAlphaOptionBkup = m_myudg->GetAlphaMode();
		m_myudg->SetAlphaMode( dwAlphaOption );
	}*/

	//	pxRadianɁBXɍ]ɂȂĂ̂ŉE]
	float fRad = AngleToRad(-fAngle);

	//	G
	MyuAssert( m_pSprite->Draw( m_pTexture, srcRect, &vctScale, &vctRtCenter, fRad, &vctPos, color ), D3D_OK,
		"CMyu2DGraphicsSurface::Draw()  m_pSprite->Draw()Ɏs" );

	/*	XvCg̓At@IvVȂۂ
	//	At@IvVɖ߂
	if ( dwAlphaOption != MGL_ALPHA_OPT_NOCHANGE )
	{
		m_myudg->SetAlphaMode( dwAlphaOptionBkup );
	}*/
}


//	GiCopyRectgpj
void CMyu2DGraphicsSurface::CopyRectToOther( CMyu2DGraphicsSurface* destSurface, RECT *srcRect, int x, int y )
{
	CreateCheck();	//	Create`FbN

	//if ( m_pSurface == NULL )
	//	MyuThrow( 0, "CMyu2DGraphicsSurface::CopyRectToOther()  m_pSurface擾Ă܂B");
	//	srcRectNULLw肳ꂽꍇ̓tŊG

	D3DXLoadSurfaceFromSurface(
		destSurface->GetSurfacePtr(), NULL, NULL,
		m_pSurface, NULL, NULL,
		D3DX_FILTER_POINT, 0 );

	/*
	RECT _srcRect;
	if ( srcRect == NULL )
	{
		srcRect = &_srcRect;
		_Rect( m_nBmpSizeX, m_nBmpSizeY, srcRect );
	}
	POINT destPoint;
	destPoint.x = x;
	destPoint.y = y;

	//	̂NbsOہ[Ƃ那

	if ( m_pSurface == destSurface->GetSurfacePtr() )
		MyuThrow(0,"CMyu2DGraphicsSurface::CopyRectToOther()  destSurfaceɎg̃T[tFXw肷邱Ƃ͏o܂B");

	//if (FAILED(d3d->CopyRects(m_pSurface, srcRect, 1, destSurface, &destPoint))) {
	//MyuAssert( d3d->CopyRects(m_pSurface, NULL, 1, destSurface, NULL), D3D_OK,
	MyuAssert( d3d->CopyRects(m_pSurface, srcRect, 1, destSurface->GetSurfacePtr(), &destPoint), D3D_OK,
		"CMyu2DGraphicsSurface::CopyRectToOther()  CopyRect()Ɏs" );
	*/
}

//	̃T[tFXCopyRect
void CMyu2DGraphicsSurface::CopyRectToThis( CMyu2DGraphicsSurface* srcSurface, RECT *srcRect, int x, int y )
{
	srcSurface->CopyRectToOther( this, srcRect, x, y );
}

/*
//	̃T[tFXCopyRect
void CMyu2DGraphicsSurface::CopyRectToThis( CMyu2DGraphicsSurface* srcSurface, RECT *srcRect, int x, int y )
{
	CreateCheck();	//	Create`FbN

	//if ( m_pSurface == NULL )
	//	MyuThrow( 0, "CMyu2DGraphicsSurface::CopyRectToThis()  m_pSurface擾Ă܂B");
	//	srcRectNULLw肳ꂽꍇ̓tŊG
	RECT _srcRect;
	if ( srcRect == NULL )
	{
		srcRect = &_srcRect;
		_Rect( m_nBmpSizeX, m_nBmpSizeY, srcRect );
	}
	POINT destPoint;
	destPoint.x = x;
	destPoint.y = y;

	if ( m_pSurface == srcSurface->GetSurfacePtr() )
		MyuThrow(0,"CMyu2DGraphicsSurface::CopyRectToThis()  srcSurfaceɎg̃T[tFXw肷邱Ƃ͏o܂B");

	//if (FAILED(d3d->CopyRects(srcSurface, srcRect, 1, m_pSurface, &destPoint))) {
	MyuAssert( d3d->CopyRects(srcSurface->GetSurfacePtr(), NULL, 0, m_pSurface, NULL), D3D_OK,
		"CMyu2DGraphicsSurface::CopyRectToThis()  CopyRect()Ɏs" );
}
*/

/*	ǂtH[}bgG[N̂ŖT|[g
//	GiCopyRectgpj
void CMyu2DGraphicsSurface::CopyRect( int x, int y, RECT *srcRect )
{
	CreateCheck();	//	Create`FbN
	CopyRectToOther( x, y, srcRect, m_myudg->_GetBackBuffer() );
}
*/

//	G̃T[tFXɐݒ肷
void CMyu2DGraphicsSurface::SetRender()
{
	CreateCheck();	//	Create`FbN

	MyuAssert( d3d->SetRenderTarget( m_pSurface, NULL ), D3D_OK, //m_myudg->lpZbuffer
		"CMyu2DGraphicsSurface::SetRender()  SetRenderTarget()Ɏs" );
}

//	NA
/*void CMyu2DGraphicsSurface::Clear()
{
	//	m_colorKey֘ÂŃftHgɂ͏oȂ̂łꂷ
	Clear( m_colorKey & 0x00ffffff );
}*/

//	NA
void CMyu2DGraphicsSurface::Clear( D3DCOLOR color )
{
	CreateCheck();	//	Create`FbN

	if ( m_bRenderTarget == TRUE )
	{
		//	݂̃_[ێiɏ}YȂj
		IDirect3DSurface8* bkupRender;
		d3d->GetRenderTarget( &bkupRender );

		SetRender();
		//d3d->Clear( 0, NULL, D3DCLEAR_TARGET, color, 1.0f, 0 );	//	|D3DCLEAR_ZBUFFER
		m_myudg->Clear( color );	//	|D3DCLEAR_ZBUFFER
		//	D3DCOLOR_FULLALPHA

		//	_[ɖ߂
		MyuAssert( d3d->SetRenderTarget( bkupRender, NULL ), D3D_OK, //m_myudg->lpZbuffer
			"CMyu2DGraphicsSurface::Clear()  _[߂̂Ɏs" );
	}
	else
	{
		//	ʂɃNAꂽT[tFX쐬ĂRs[Aƌʓ|ȏ(LD`)
		CMyu2DGraphicsSurface workSurface;
		workSurface.Init( m_myudg );
		workSurface.Create();	//	_OTRUEɂȂƖċAĂ܂
		workSurface.Clear( color );
		CopyRectToThis( &workSurface );
	}
}

//	w肳ꂽ`̈hԂ
void CMyu2DGraphicsSurface::Paint( RECT* rect, D3DCOLOR color )
{
	CreateCheck();	//	Create`FbN

	if ( m_bRenderTarget == TRUE )
	{
		//	݂̃_[ێiɏ}YȂj
		IDirect3DSurface8* bkupRender;
		d3d->GetRenderTarget( &bkupRender );

		SetRender();
		//d3d->Clear( 0, NULL, D3DCLEAR_TARGET, color, 1.0f, 0 );	//	|D3DCLEAR_ZBUFFER
		m_myudg->Paint( rect, color );	//	|D3DCLEAR_ZBUFFER

		//	_[ɖ߂
		MyuAssert( d3d->SetRenderTarget( bkupRender, NULL ), D3D_OK, //m_myudg->lpZbuffer
			"CMyu2DGraphicsSurface::Clear()  _[߂̂Ɏs" );
	}
	else
	{
		//	ʂɃNAꂽT[tFX쐬ĂRs[Aƌʓ|ȏ(LD`)
		CMyu2DGraphicsSurface workSurface;
		workSurface.Init( m_myudg );
		workSurface.Create();	//	_OTRUEɂȂƖċAĂ܂
		workSurface.Paint( rect, color );
		CopyRectToThis( &workSurface );
	}
}

