//////////////////////////////////////////////////////////
//
//	MglLayers2
//		- MglGraphicManager C[NX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MglLayers2.h"


//	RXgN^
CMglLayers2::CMglLayers2()
{
	p_layerInfos = new LAYERINFOS_MAP;
	p_indexs = new INDEXS_MAP;

	m_pPrevTargetSurface = NULL;
}

//	fXgN^
CMglLayers2::~CMglLayers2()
{
	Release();

	SAFE_DELETE( p_layerInfos );
	SAFE_DELETE( p_indexs );
}

//	J
void CMglLayers2::Release()
{
	CMglImageManager::Release();
	DeleteAll();
}

//	SẴC[폜i_łRelease()Ɠj
void CMglLayers2::DeleteAll()
{
	p_layerInfos->clear();
	p_indexs->clear();

	CMglImageManager::DeleteAll();
}

//	
void CMglLayers2::Init( CMglGraphicManager *in_m_myudg, const char* in_szDummyFile, D3DCOLOR colorKey )
{
	//	ϐփRs[
	strcpy( m_szDummyFile, in_szDummyFile );
	m_colorKey = colorKey;

	//	CMglImageManagerInit()Ăяo
	CMglImageManager::Init( in_m_myudg );

	//	_OpT[tFX̏
	m_renderingSurface.Init( in_m_myudg );
	m_renderingSurface.Create();
}

//	C[̒ǉ
void CMglLayers2::Add( const char *szBufferName )
{
	CMglImage *pSurface = AddEntry( szBufferName );

	//	CreateFromFile()͗ǂG[N̂Exception
	try
	{
		pSurface->Create( m_szDummyFile, TRUE, m_colorKey );
		//pSurface->CreateFromFile( m_szDummyFile, TRUE, m_colorKey );
		//pSurface->CreateFromFile( m_szDummyFile, FALSE, m_colorKey );	//	dCCC_|P|

		//	_~[T[tFX̃TCY`FbN
		if ( pSurface->GetBmpWidth() != m_myudg->GetDispX() ||
			 pSurface->GetBmpHeight() != m_myudg->GetDispY() )
		{
			MyuThrow( 0, "_~[T[tFX͉ʂ̃TCYƈvĂȂ΂܂B" );
		}

		pSurface->Clear();
	}
	catch( MyuCommonException except )
	{
		static MyuCommonException except2;
		sprintf( except2.szErrMsg, "CMglLayers2::Add(\"%s\")\r\n"
			"0x%08x %s", szBufferName, except.nErrCode, except.szErrMsg );
		throw except2;
	}
	catch( ... )
	{
		MyuThrow( 0, "CMglLayers2::Add()  Unknown Exception Error." );
	}
}

//	C[̒ǉiPrej
CMglImage* CMglLayers2::AddEntry( const char *szBufferName )
{
	//	indexs
	INDEXS_MAP &indexs = *p_indexs;
	LAYERINFOS_MAP &layerInfos = *p_layerInfos;
	indexs[layerInfos.size()] = szBufferName;

	//	layerInfos
	LAYERINFO layerInfo;
	ZeroMemory( &layerInfo, sizeof(LAYERINFO) );
	layerInfo.bShow = TRUE;
	layerInfo.color = 0xffffffff;
	layerInfos[szBufferName] = layerInfo;

	return CMglImageManager::Add( szBufferName );
}

//	C[擾
CMglImage* CMglLayers2::GetRenderingSurface( const char *szLayerName )
{
	InitCheck();

	//	Õ_O𔽉f
	AdaptRenderingSurface();

	//	^[QbgT[tFX擾ARs[Ă
	CMglImageManager::Get( szLayerName )->CopyRectToOther(&m_renderingSurface);

	//	^[QbgT[tFXێ
	m_pPrevTargetSurface = CMglImageManager::Get( szLayerName );
	if ( m_pPrevTargetSurface == NULL )
		MyuThrow( 0, "CMglLayers2::GetRenderingSurface()  ȂNULLdŗ܂i" );

	//	Ũ_OpT[tFX𕜋A
	return &m_renderingSurface;
}

//	Õ_O𔽉f
void CMglLayers2::AdaptRenderingSurface()
{
	//	m_pPrevTargetSurfaceNULLȂ̂őÕ_O͖
	if ( m_pPrevTargetSurface != NULL )
	{
		m_renderingSurface.CopyRectToOther(m_pPrevTargetSurface);

		//	
		m_pPrevTargetSurface = NULL;
	}
}

//	exݒ肷ł
void CMglLayers2::SetLayerOption( const char *szLayerName, RECT *rect, D3DCOLOR color )
{
	SetLayerOption( szLayerName, rect );
	SetLayerOption( szLayerName, color );
}

//	exݒ肷ł
void CMglLayers2::SetLayerOption( const char *szLayerName, RECT *rect )
{
	InitCheck();

	//	ẮcH
	if ( p_layerInfos->find( szLayerName ) == p_layerInfos->end() )
	{
		MyuThrow( 0, "CMglLayers2::SetLayerOption()  C[ %s ݂͑܂B", szLayerName );
	}

	LAYERINFOS_MAP &layerInfos = *p_layerInfos;

	if ( rect == NULL )
		ZeroMemory( &layerInfos[szLayerName].rect, sizeof(RECT) );	//	NULLȂ0,0,0,0
	else
		layerInfos[szLayerName].rect = *rect;						//	\̂܂邱ҁ[
}

//	exݒ肷ł
void CMglLayers2::SetLayerOption( const char *szLayerName, D3DCOLOR color )
{
	InitCheck();

	//	ẮcH
	if ( p_layerInfos->find( szLayerName ) == p_layerInfos->end() )
	{
		MyuThrow( 0, "CMglLayers2::SetLayerOption()  C[ %s ݂͑܂B", szLayerName );
	}

	LAYERINFOS_MAP &layerInfos = *p_layerInfos;

	layerInfos[szLayerName].color = color;
}


//	ʂւ̔f
void CMglLayers2::OnDraw( D3DCOLOR baseColor )
{
	InitCheck();

	//if ( p_buffers->size() == 0 )
	//	MyuThrow( 0, "CMglLayers2::OnDraw() C[łB" );

	//	Õ_O𔽉f
	AdaptRenderingSurface();

	//	obNobt@Ƀ_OBłɉʂNA
	m_myudg->SetRenderBackBuffer();
	m_myudg->Clear( baseColor );

	//	C[[v
	for ( int i=0; i<m_buffers.Size(); i++ )
	{
		LAYERINFO *pInfo = &iLayerInfos(i);
		CMglImage *pSfc = iBuffers(i);

		if ( pInfo->bShow == TRUE )
		{
			//pSfc->XDraw();
			//pSfc->Draw( pInfo->rect.left, pInfo->rect.top, NULL, pInfo->color );

			if ( pInfo->rect.left == pInfo->rect.right || pInfo->rect.top == pInfo->rect.bottom )
				pSfc->Draw( pInfo->rect.left, pInfo->rect.top, NULL, pInfo->color );
			else
				pSfc->Draw( pInfo->rect.left, pInfo->rect.top, &pInfo->rect, pInfo->color );
		}
	}

	m_myudg->UpdateScreen();
}

