//////////////////////////////////////////////////////////
//
//	MglDirectShowBase
//		- DirectMusicNX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MglDirectShowBase.h"

/*
#ifdef _DEBUG
	#pragma comment(lib, "Strmbasd.lib")
#else
	#pragma comment(lib, "Strmbase.lib")
#endif//_DEBUG
*/

//template class DLL_EXP std::map<std::string,IDirectMusicSegment8*>;

#define ENBL_CHK()	if(m_flgEnable!=TRUE)return;
	

/*	log2(x)̌vZs	*/
double _MGL_log2(double x)
{
	const double y=1;
	__asm {
		; st(0)=x, st(1)=y ƓĂ
		; exp(y * log(x))߂
		fld y;
		fld x;
        fyl2x;
		fstp x;
    }
	return x;
}

//	RXgN^
CMglDirectShowBase::CMglDirectShowBase()
{
	m_pGraph = NULL;
	m_pControl = NULL;
	m_pEvent = NULL;
	m_pSeeking = NULL;
	m_pAudioRendererFilter = NULL;
	m_pBasicAudio = NULL;
	m_bRunReady = FALSE;
	//m_bPausing = TRUE;	TRUEɂƏPause()ĂĐBEEE܂ʂ͍ĐĂȂ̂PauseōĐ̂͂ƈႤ낤EEE
	m_bPausing = FALSE;
	m_hWnd = NULL;
}

//	fXgN^
CMglDirectShowBase::~CMglDirectShowBase()
{
	Release();
}

//	J
void CMglDirectShowBase::Release()
{
	SAFE_RELEASE(m_pGraph);
	SAFE_RELEASE(m_pControl);
	SAFE_RELEASE(m_pEvent);
	SAFE_RELEASE(m_pSeeking);
	SAFE_RELEASE(m_pAudioRendererFilter);
	SAFE_RELEASE(m_pBasicAudio);
}

//	
void CMglDirectShowBase::Init( HWND hWnd )
{
	CMglStackInstance("CMglDirectShowBase::Init");

	if ( hWnd == NULL )
		hWnd = GetDefaultHwnd();
	m_hWnd = hWnd;

	//	tB^Ot̃CX^X𐶐
	MyuAssert( CoCreateInstance(CLSID_FilterGraph, NULL, 
                     CLSCTX_INPROC_SERVER, IID_IGraphBuilder,
                     (void**)&m_pGraph), S_OK,
		"CMglDirectShowBase::Init()  CoCreateInstance(IGraphBuilder)ɎsB" );

	//	tB^OtIMediaControl擾
	MGL_H_ASSERT( m_pGraph->QueryInterface(IID_IMediaControl, (void **)&m_pControl) );
//	MyuAssert( m_pGraph->QueryInterface(IID_IMediaControl, (void **)&m_pControl), S_OK,
//		"CMglDirectShowBase::Init()  QueryInterface(IMediaControl)ɎsB" );

	//	tB^OtIMediaEvent擾
	MyuAssert( m_pGraph->QueryInterface(IID_IMediaEvent, (void **)&m_pEvent), S_OK,
		"CMglDirectShowBase::Init()  QueryInterface(IMediaEvent)ɎsB" );

	//	tB^OtIMediaSeeking擾
	MyuAssert( m_pGraph->QueryInterface(IID_IMediaSeeking, (void **)&m_pSeeking), S_OK,
		"CMglDirectShowBase::Init()  QueryInterface(IMediaSeeking)ɎsB" );
	
	EnableAudioExControl();
}

//	ǂݍ
void CMglDirectShowBase::Load( const char* szMediaFile )
{
	InitCheck();

	WCHAR wstrFileName[32000*2+1];
	ZeroMemory( wstrFileName, sizeof(wstrFileName) );
	MultiByteToWideChar(CP_ACP, 0, szMediaFile, strlen(szMediaFile), wstrFileName, sizeof(wstrFileName));

	//	Đt@Cw肷
	HRESULT hRet = m_pGraph->RenderFile(wstrFileName, NULL);

	switch( hRet )
	{
	case S_OK:
		break;
	case VFW_S_AUDIO_NOT_RENDERED:	//	I[fBI Xg[ĐłȂBK؂ȃ_ȂB
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ̓T|[gĂȂI[fBIXg[łB", szMediaFile );

	case VFW_S_VIDEO_NOT_RENDERED:	//	rfI Xg[ĐłȂBK؂ȃ_ȂB
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ̓T|[gĂȂrfIXg[łB", szMediaFile );

	case VFW_S_PARTIAL_RENDER:		//	̃[r[ɃT|[gȂtH[}bg̃Xg[܂܂ĂB
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ̓T|[gĂȂ[r[Xg[܂݂܂B", szMediaFile );

	case E_INVALIDARG:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  ُłB" );

	case E_OUTOFMEMORY:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" Đ̂ɏ\ȃ܂B", szMediaFile );

	case VFW_E_CANNOT_CONNECT:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ڑm钆ԃtB^̑gݍ킹ȂB", szMediaFile );

	case VFW_E_CANNOT_LOAD_SOURCE_FILTER:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ̃\[X tB^[hłȂB", szMediaFile );

	case VFW_E_CANNOT_RENDER:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" Xg[_OtB^̑gݍ킹ȂB", szMediaFile );

	case VFW_E_INVALID_FILE_FORMAT:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@CtH[}bgłB %s", szMediaFile );

	case VFW_E_NOT_FOUND:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ܂B", szMediaFile );

	case VFW_E_NOT_IN_GRAPH:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" tB^ Otɑ݂ȂIuWFNgɗvꂽ֐słȂB", szMediaFile );

	case VFW_E_UNKNOWN_FILE_TYPE:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ̃fBA^CvFo܂B", szMediaFile );

	case VFW_E_UNSUPPORTED_STREAM:
		MyuThrow( hRet, "CMglDirectShowBase::Load()  t@C \"%s\" ̓T|[gĂȂfBA`łB", szMediaFile );

	default:
		MyuThrow( hRet, "t@C \"%s\" ̓ǂݍ݂ɎsB", szMediaFile );
	}

	SetVolume(100);
}

//	ǂݍ񂾂̂j
void CMglDirectShowBase::Unload()
{
	InitCheck();
	//ENBL_CHK();

	Release();
	Init(m_hWnd);

#if 1 == 0
	//IEnumFilters *pEnumFilters = NULL;
	auto_release<IEnumFilters*> pEnumFilters = NULL;
	MGL_H_ASSERT( m_pGraph->EnumFilters(&pEnumFilters) );

	//ULONG ulFetched;	NULLł炵
	IBaseFilter *pFilter = NULL;
	MGL_H_ASSERT( pEnumFilters->Next(1, &pFilter, NULL) );

	MGL_H_ASSERT( m_pGraph->RemoveFilter(pFilter) );
//	MGL_H_ASSERT2( m_pGraph->RemoveFilter(NULL), "CMglDirectShowBase::Unload()" );
//	MyuAssert( m_pGraph->RemoveFilter(m_pGraph), S_OK,
//		"CMglDirectShowBase::Unload()  m_pGraph->RemoveFilter()ɎsB" );

    pFilter->Release();
#endif
}

//	Đ
inline void CMglDirectShowBase::Play()
{
	InitCheck();
	//ENBL_CHK();

	if ( m_bPausing == FALSE )
	{
		/*	2009/09/13  ܂AĐŏAʂ˂H	*/
		Stop();
	}

	/*MyuAssert( m_pControl->Run(), S_OK,
		"CMglDirectShowBase::Play()  m_pControl->Run()ɎsB" );*/
	if ( m_pControl->Run() != S_OK ){
		/*OAFilterState fs;
		HRESULT hRet = S_FALSE;
		for(int i=0; i<50; i++, Sleep(100)){
			hRet = m_pControl->GetState(200,&fs);
			if ( hRet != S_OK )
				continue;
		}
		if ( hRet != S_OK ){
			MyuThrow( hRet, "CMglDirectShowBase::Play()  m_pControl->Run()ɎsB(GetState() failed.)" );
		}*/
		/*MyuAssert( m_pControl->GetState(1000,&fs), S_OK,
			"CMglDirectShowBase::Play()  m_pControl->GetState()ɎsB" );*/
		//MyuThrow( 0, "CMglDirectShowBase::Play()  m_pControl->Run()ɎsB" );
	}

	m_bPausing = FALSE;
}

//	~
inline void CMglDirectShowBase::Stop()
{
	InitCheck();
	//ENBL_CHK();

	MyuAssert( m_pControl->Stop(), S_OK,
		"CMglDirectShowBase::Stop()  m_pControl->Stop()ɎsB" );

	SeekToHead();
}

//	ꎞ~
inline void CMglDirectShowBase::Pause()
{
	InitCheck();
	//ENBL_CHK();

	if ( m_bPausing == TRUE )
		Play();

	else
	{
		//MyuAssert( m_pControl->Pause(), S_OK,	//	ĐĂȂƃRPۂBȂStopłi
		MyuAssert( m_pControl->Stop(), S_OK,
			"CMglDirectShowBase::Pause()  m_pControl->Pause()ɎsB" );

		m_bPausing = TRUE;
	}
}

//	{[̐ݒ
inline void CMglDirectShowBase::SetVolume( int nVolume )
{
	//EnableAudioExControl();
	//m_pBasicAudio->put_Volume(nVolume*100-10000);
	//long nVol = ( nVolume == -10000 ? 0 : _MGL_log2(100.0f/nVolume) * -1000 );
	long nPutVol = -10000;
	if ( nVolume != 0 )
		nPutVol = _MGL_log2(100.0/nVolume) * -1000;
	if ( nPutVol < -10000 )
		nPutVol = -10000;
	m_pBasicAudio->put_Volume( nPutVol );
}

//	pݒ
inline void CMglDirectShowBase::SetBalance( int nBalance )
{
	//EnableAudioExControl();
	//m_pBasicAudio->put_Balance(nBalance*100);
	long nPutPan = 0;
	if ( nBalance != 0 )
		nPutPan = _MGL_log2(100.0/ (100-( nBalance < 0 ? nBalance*-1 : nBalance)) ) * 1000;
	if ( nBalance < 0 )
		nPutPan *= -1;
	m_pBasicAudio->put_Balance( nPutPan );
}

inline void CMglDirectShowBase::EnableAudioExControl()
{
	if ( m_pAudioRendererFilter == NULL )
		// _tB^[
		MyuAssert( CoCreateInstance(CLSID_AudioRender, NULL,
			CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&m_pAudioRendererFilter), S_OK,
			"CMglDirectShowBase::EnableAudioExControl()  CoCreateInstance(IBaseFilter)ɎsB" );
	
	if ( m_pBasicAudio == NULL )
		// IBasicAudioC^[tF[X̏
		MyuAssert( m_pAudioRendererFilter->QueryInterface(IID_IBasicAudio, (void**)&m_pBasicAudio), S_OK,
			"CMglDirectShowBase::EnableAudioExControl()  QueryInterface(IID_IBasicAudio)ɎsB" );

	m_pGraph->AddFilter(m_pAudioRendererFilter, NULL);
}


//	ʒuύX
void CMglDirectShowBase::SeekTo( long nSeekTime, DWORD dwFlg )
{
	InitCheck();

	LONGLONG llSeekTime = nSeekTime;
	DWORD dwCurrentFlags = 0;

	switch(dwFlg)
	{
	case SEEK_SET:	dwCurrentFlags = AM_SEEKING_AbsolutePositioning;	break;
	case SEEK_CUR:	dwCurrentFlags = AM_SEEKING_RelativePositioning;	break;
	default:
		MyuThrow(41166, "CMglDirectShowBase::SeekTo()  dwFlg = %d ͕słB", dwFlg);
	}

	//擪ʒuɐݒ肷
	MyuAssert( m_pSeeking->SetPositions(&llSeekTime,
		dwCurrentFlags, NULL, AM_SEEKING_NoPositioning), S_OK,
		"CMglDirectShowBase::SeekTo()  m_pSeeking->SetPositions()ɎsB" );

}
