/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import java.util.Hashtable;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions._TransactionFactoryImplBase;
import tyrex.tm.impl.ControlImpl;
import tyrex.tm.impl.TransactionDomainImpl;
import tyrex.tm.impl.TransactionImpl;

public final class TransactionFactoryImpl
extends _TransactionFactoryImplBase
implements Sender,
Receiver {
    private final TransactionDomainImpl _txDomain;
    private static final Hashtable _txMap = new Hashtable();

    TransactionFactoryImpl(TransactionDomainImpl transactionDomainImpl) {
        if (transactionDomainImpl == null) {
            throw new IllegalArgumentException("Argument 'txDomain' is null");
        }
        this._txDomain = transactionDomainImpl;
    }

    public static void associate(String string) throws InvalidTransactionException, SystemException {
        Entry entry = (Entry)_txMap.get(string);
        if (null != entry) {
            if (null != entry._txManager.getTransaction()) {
                entry._txManager.suspend();
            }
            entry._txManager.resume((Transaction)entry._tx);
        }
    }

    public Control create(int n) {
        try {
            TransactionImpl transactionImpl = this._txDomain.createTransaction(null, n);
            Control control = transactionImpl.getControl();
            if (this._txDomain._orb != null) {
                this._txDomain._orb.connect((Object)control);
                String string = this._txDomain._orb.object_to_string((Object)control.get_coordinator());
                _txMap.put(string, new Entry(this._txDomain.getTransactionManager(), transactionImpl));
                transactionImpl.registerSynchronization(new InternalSynchronization(string));
            }
            return control;
        }
        catch (Exception exception) {
            throw new INVALID_TRANSACTION();
        }
    }

    public Control recreate(PropagationContext propagationContext) {
        try {
            TransactionImpl transactionImpl = this._txDomain.recreateTransaction(propagationContext);
            Control control = transactionImpl.getControl();
            if (this._txDomain._orb != null) {
                this._txDomain._orb.connect((Object)control);
            }
            return control;
        }
        catch (Exception exception) {
            throw new INVALID_TRANSACTION();
        }
    }

    public void sending_request(int n, PropagationContextHolder propagationContextHolder) {
        TransactionImpl transactionImpl = (TransactionImpl)this._txDomain._txManager.getTransaction();
        if (transactionImpl == null) {
            throw new TRANSACTION_REQUIRED();
        }
        propagationContextHolder.value = ((ControlImpl)transactionImpl.getControl()).getPropagationContext();
    }

    public void received_request(int n, PropagationContext propagationContext) {
        try {
            ControlImpl controlImpl = (ControlImpl)this.recreate(propagationContext);
            try {
                this._txDomain._txManager.resume(controlImpl.getTransaction());
            }
            catch (IllegalStateException illegalStateException) {
                throw new InvalidControl();
            }
            catch (InvalidTransactionException invalidTransactionException) {
                throw new InvalidControl();
            }
            catch (SystemException systemException) {
                throw new INVALID_TRANSACTION(systemException.toString());
            }
        }
        catch (InvalidControl invalidControl) {
            throw new INVALID_TRANSACTION();
        }
    }

    public void sending_reply(int n, PropagationContextHolder propagationContextHolder) {
        TransactionImpl transactionImpl = (TransactionImpl)this._txDomain._txManager.getTransaction();
        if (transactionImpl == null) {
            throw new TRANSACTION_ROLLEDBACK();
        }
        if (transactionImpl.getPropagationContext() == null) {
            while (transactionImpl.getParent() != null) {
                transactionImpl = (TransactionImpl)transactionImpl.getParent();
            }
            if (transactionImpl.getPropagationContext() != null) {
                try {
                    transactionImpl.getPropagationContext().current.coord.rollback_only();
                }
                catch (Inactive inactive) {
                    // empty catch block
                }
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        propagationContextHolder.value = transactionImpl.getPropagationContext();
    }

    public void received_reply(int n, PropagationContext propagationContext, Environment environment) throws WrongTransaction {
        if (environment.exception() != null) {
            try {
                this._txDomain._txManager.setRollbackOnly();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SystemException systemException) {
                throw new INVALID_TRANSACTION(systemException.toString());
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        TransactionImpl transactionImpl = (TransactionImpl)this._txDomain._txManager.getTransaction();
        if (transactionImpl == null || ((ControlImpl)transactionImpl.getControl()).getCoordinator() != propagationContext.current.coord) {
            throw new WrongTransaction();
        }
    }

    private static class Entry {
        private final TransactionManager _txManager;
        private final TransactionImpl _tx;

        private Entry(TransactionManager transactionManager, TransactionImpl transactionImpl) {
            this._txManager = transactionManager;
            this._tx = transactionImpl;
        }
    }

    private static class InternalSynchronization
    implements Synchronization {
        private final String _key;

        private InternalSynchronization(String string) {
            this._key = string;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            _txMap.remove(this._key);
        }
    }
}

