/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import com.google.common.collect.Lists;
import java.util.List;
import org.reflections.ReflectionsException;
import org.reflections.scanners.AbstractScanner;
import org.reflections.serializers.JavaCodeSerializer;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesScanner
extends AbstractScanner {
    private static final List<String> javaCodeSerializerInterfaces = Lists.newArrayList((Object[])new String[]{JavaCodeSerializer.IElement.class.getName(), JavaCodeSerializer.IPackage.class.getName(), JavaCodeSerializer.IClass.class.getName(), JavaCodeSerializer.IField.class.getName(), JavaCodeSerializer.IMethod.class.getName()});

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class") && !file.endsWith("package-info.class");
    }

    @Override
    public void scan(Vfs.File file) {
        try {
            Object cls = this.getMetadataAdapter().getOfCreateClassObject(file);
            this.scan(cls, file);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not create class file from " + file.getName(), e);
        }
    }

    private void scan(Object cls, Vfs.File file) {
        if (TypesScanner.isJavaCodeSerializer(this.getMetadataAdapter().getInterfacesNames(cls))) {
            return;
        }
        String className = this.getMetadataAdapter().getClassName(cls);
        this.getStore().put((Object)className, (Object)className);
    }

    @Override
    public void scan(Object cls) {
        throw new UnsupportedOperationException("should not get here");
    }

    public static boolean isJavaCodeSerializer(List<String> interfacesNames) {
        return interfacesNames.size() == 1 && javaCodeSerializerInterfaces.contains(interfacesNames.get(0));
    }
}

