/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc.xa;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import tyrex.resource.jdbc.xa.XADataSourceImpl;

public class EnabledDataSource
extends XADataSourceImpl
implements DataSource,
Referenceable,
ObjectFactory,
Serializable {
    private int _loginTimeout;
    private String _user;
    private String _password;
    private String _description = "Enabled DataSource";
    private String _driverName;
    private String _driverClassName;
    private transient PrintWriter _logWriter = DriverManager.getLogWriter();
    private transient Driver _driver;

    public EnabledDataSource() {
        this._loginTimeout = DriverManager.getLoginTimeout();
        this.setIsolationLevel(8);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this._user, this._password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        Connection connection;
        if (this._driver == null) {
            this._driverName = this.createJDBCURL();
            if (null == this._driverName) {
                throw new SQLException("The driver name is not set.");
            }
            try {
                if (this._driverClassName != null) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    this._driver = classLoader == null ? (Driver)Class.forName(this._driverClassName).newInstance() : (Driver)classLoader.loadClass(this._driverClassName).newInstance();
                }
            }
            catch (Exception exception) {
                if (this._logWriter != null) {
                    this._logWriter.println("DataSource: Failed to load JDBC driver: " + exception.toString());
                }
                throw new SQLException(exception.toString());
            }
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put("loginTimeout", Integer.toString(this._loginTimeout));
        if (string == null) {
            string = this._user;
            string2 = this._password;
        }
        if (null != string) {
            ((Hashtable)properties).put("user", string);
        }
        if (null != string2) {
            ((Hashtable)properties).put("password", string2);
        }
        try {
            connection = this._driver.connect(this._driverName, properties);
        }
        catch (SQLException sQLException) {
            if (this._logWriter != null) {
                this._logWriter.println("DataSource: getConnection failed " + sQLException);
            }
            throw sQLException;
        }
        return connection;
    }

    protected String createJDBCURL() {
        if (null == this._driverName || 0 == this._driverName.length()) {
            return null;
        }
        if (this._driverName.startsWith("jdbc:")) {
            return this._driverName;
        }
        return "jdbc" + (':' == this._driverName.charAt(0) ? "" : ":") + this._driverName;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        if (printWriter != null) {
            this._logWriter = printWriter;
        }
    }

    public synchronized void setDriverName(String string) {
        if (this._driver != null) {
            throw new IllegalStateException("Cannot change driver name after a connection has been opened");
        }
        this._driverName = null == string ? string : string.trim();
    }

    public String getDriverName() {
        return this._driverName;
    }

    public void setDriverClassName(String string) {
        if (this._driver != null) {
            throw new IllegalStateException("Cannot change driver name after a connection has been opened");
        }
        this._driverClassName = string;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public void setLoginTimeout(int n) {
        this._loginTimeout = n;
    }

    public synchronized int getLoginTimeout() {
        return this._loginTimeout;
    }

    public synchronized void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException("DataSource: Argument 'description' is null");
        }
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public synchronized void setPassword(String string) {
        this._password = string;
    }

    public String getPassword() {
        return this._password;
    }

    public synchronized void setUser(String string) {
        this._user = string;
    }

    public String getUser() {
        return this._user;
    }

    public String getIsolationLevelAsString() {
        switch (this.getIsolationLevel()) {
            case 1: {
                return "ReadUncommitted";
            }
            case 2: {
                return "ReadCommitted";
            }
            case 4: {
                return "RepeatableRead";
            }
            case 8: {
                return "Serializable";
            }
        }
        return null;
    }

    public void setIsolationLevel(String string) {
        if (string == null) {
            this.setIsolationLevel(2);
        } else if (string.equals("ReadUncommitted")) {
            this.setIsolationLevel(1);
        } else if (string.equals("ReadCommitted")) {
            this.setIsolationLevel(2);
        } else if (string.equals("RepeatableRead")) {
            this.setIsolationLevel(4);
        } else if (string.equals("Serializable")) {
            this.setIsolationLevel(8);
        } else {
            this.setIsolationLevel(2);
        }
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() == this.getClass()) {
            return false;
        }
        EnabledDataSource enabledDataSource = (EnabledDataSource)object;
        if (this._driverName == null) {
            return null == enabledDataSource._driverName;
        }
        return this._driverName.equals(enabledDataSource._driverName);
    }

    public String toString() {
        return this._description;
    }

    public synchronized Reference getReference() {
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        reference.add(new StringRefAddr("description", this._description));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this._loginTimeout)));
        if (this._driverName == null) {
            reference.add(new StringRefAddr("driverName", "no driver"));
        } else {
            reference.add(new StringRefAddr("driverName", this._driverName));
        }
        if (this._driverClassName != null) {
            reference.add(new StringRefAddr("driverClassName", this._driverClassName));
        }
        if (this._user != null) {
            reference.add(new StringRefAddr("user", this._user));
        }
        if (this._password != null) {
            reference.add(new StringRefAddr("password", this._password));
        }
        if (this.getIsolationLevelAsString() != null) {
            reference.add(new StringRefAddr("isolationLevel", this.getIsolationLevelAsString()));
        }
        reference.add(new StringRefAddr("transactionTimeout", Integer.toString(this.getTransactionTimeout())));
        reference.add(new StringRefAddr("ignoreIsolationLevel", this.getIgnoreIsolationLevel() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if (reference.getClassName().equals(this.getClass().getName())) {
                EnabledDataSource enabledDataSource;
                try {
                    enabledDataSource = (EnabledDataSource)Class.forName(reference.getClassName()).newInstance();
                }
                catch (Exception exception) {
                    throw new NamingException(exception.toString());
                }
                enabledDataSource._driverName = (String)reference.get("driverName").getContent();
                enabledDataSource._description = (String)reference.get("description").getContent();
                enabledDataSource._loginTimeout = Integer.parseInt((String)reference.get("loginTimeout").getContent());
                RefAddr refAddr = reference.get("driverClassName");
                if (refAddr != null) {
                    enabledDataSource._driverClassName = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("user")) != null) {
                    enabledDataSource._user = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("password")) != null) {
                    enabledDataSource._password = (String)refAddr.getContent();
                }
                if ((refAddr = reference.get("transactionTimeout")) != null) {
                    enabledDataSource.setTransactionTimeout(Integer.parseInt((String)refAddr.getContent()));
                }
                if ((refAddr = reference.get("isolationLevel")) != null) {
                    enabledDataSource.setIsolationLevel((String)refAddr.getContent());
                }
                if ((refAddr = reference.get("ignoreIsolationLevel")) != null) {
                    enabledDataSource.setIgnoreIsolationLevel(Boolean.valueOf((String)refAddr.getContent()));
                }
                return enabledDataSource;
            }
            throw new NamingException("DataSource: Reference not constructed from class " + this.getClass().getName());
        }
        if (object instanceof Remote) {
            return object;
        }
        return null;
    }
}

