package models.services
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._

case class ProjectManager() {
  
  def getByName(name: String):Project = {
    return PartsListDb.projects.where(p => p.name === name).head
  }
  
  def getProjectList(request: play.api.mvc.Request[play.api.mvc.AnyContent]): String = {
       var projectList:String=""
      inTransaction {
	    val projects =PartsListDb.projects.where(p => p.name like request.getQueryString("q").get + "%")
	    for(project <- projects) {
	      projectList = projectList.concat(project.name)
	      projectList = projectList.concat("\n")
	    }
	  }
    return projectList
  }

}