/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.grapher.NameFactory;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.util.;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortNameFactory
implements NameFactory {
    @Override
    public String getMemberName(Member member) {
        if (member instanceof Constructor) {
            return "<init>";
        }
        if (member instanceof Method) {
            return "#" + member.getName() + "(...)";
        }
        return member.getName();
    }

    @Override
    public String getAnnotationName(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        Class<? extends Annotation> annotationType = key.getAnnotationType();
        if (annotation != null) {
            annotationType = annotation.annotationType();
            String annotationString = ((Object)annotation).toString();
            String canonicalName = annotationType.getName();
            String simpleName = annotationType.getSimpleName();
            return annotationString.replace(canonicalName, simpleName).replace("()", "");
        }
        if (annotationType != null) {
            return "@" + annotationType.getSimpleName();
        }
        return "";
    }

    @Override
    public String getClassName(Key<?> key) {
        TypeLiteral typeLiteral = key.getTypeLiteral();
        return this.stripPackages(typeLiteral.toString());
    }

    @Override
    public String getInstanceName(Object instance) {
        if (instance instanceof ProviderMethod) {
            return this.getMethodString(((ProviderMethod)instance).getMethod());
        }
        if (instance instanceof CharSequence) {
            return "\"" + instance + "\"";
        }
        try {
            if (instance.getClass().getMethod("toString", new Class[0]).getDeclaringClass().equals(Object.class)) {
                return this.stripPackages(instance.getClass().getName());
            }
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        return instance.toString();
    }

    @Override
    public String getSourceName(Object source) {
        if (source instanceof Method) {
            source = .StackTraceElements.forMember((Member)((Method)source));
        }
        if (source instanceof StackTraceElement) {
            return this.getFileString((StackTraceElement)source);
        }
        return this.stripPackages(source.toString());
    }

    protected String getFileString(StackTraceElement stackTraceElement) {
        return stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber();
    }

    protected String getMethodString(Method method) {
        ArrayList paramStrings = .Lists.newArrayList();
        for (Class<?> paramType : method.getParameterTypes()) {
            paramStrings.add(paramType.getSimpleName());
        }
        String paramString = .Join.join((String)", ", (Iterable)paramStrings);
        return "#" + method.getName() + "(" + paramString + ")";
    }

    private String stripPackages(String str) {
        return str.replaceAll("(^|[< .\\(])([a-z0-9]+\\.)*", "$1");
    }
}

