/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc;

import javax.sql.PooledConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import tyrex.resource.jdbc.ConnectionPool;
import tyrex.services.Clock;
import tyrex.tm.XAResourceCallback;

final class PoolEntry
implements XAResourceCallback {
    protected final PooledConnection _pooled;
    protected final int _hashCode;
    protected PoolEntry _nextEntry;
    protected int _state;
    protected final XAResource _xaResource;
    protected long _timeStamp;
    protected final String _user;
    protected final String _password;
    private final ConnectionPool _connectionPool;
    protected int _enlistCount;
    protected boolean _enlistedInTransaction;

    protected PoolEntry(ConnectionPool connectionPool, PooledConnection pooledConnection, int n, XAResource xAResource, String string, String string2) {
        if (connectionPool == null) {
            throw new IllegalArgumentException("Argument connectionPool is null");
        }
        if (pooledConnection == null) {
            throw new IllegalArgumentException("Argument pooled is null");
        }
        this._connectionPool = connectionPool;
        this._pooled = pooledConnection;
        this._hashCode = n;
        this._xaResource = xAResource;
        this._user = string;
        this._password = string2;
        this._state = 1;
        this._timeStamp = Clock.clock();
        this._enlistCount = 0;
        this._enlistedInTransaction = false;
    }

    public void enlist(Xid xid) {
        ConnectionPool connectionPool = this._connectionPool;
        synchronized (connectionPool) {
            this._enlistedInTransaction = true;
            ++this._enlistCount;
            if (this._connectionPool._category.isDebugEnabled()) {
                this._connectionPool._category.debug((Object)(this._pooled + " enlisted in transaction " + this._enlistCount));
            }
        }
    }

    public void fail(Xid xid) {
        ConnectionPool connectionPool = this._connectionPool;
        synchronized (connectionPool) {
            --this._enlistCount;
            if (this._connectionPool._category.isDebugEnabled()) {
                this._connectionPool._category.debug((Object)(this._pooled + " xa resource failed " + this._enlistCount));
            }
            if (2 == this._state && 0 == this._enlistCount) {
                this._connectionPool.release(this._pooled, true);
            }
        }
    }

    public void boundary(Xid xid, boolean bl) {
        ConnectionPool connectionPool = this._connectionPool;
        synchronized (connectionPool) {
            --this._enlistCount;
            if (this._connectionPool._category.isDebugEnabled()) {
                this._connectionPool._category.debug((Object)(this._pooled + " transaction ended " + this._enlistCount));
            }
            if (2 == this._state && 0 == this._enlistCount) {
                this._connectionPool.release(this._pooled, true);
            }
        }
    }
}

