/*
 * Decompiled with CFR 0.152.
 */
package tyrex.naming.java;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import tyrex.naming.EnvContext;

public final class JavaContext
implements Context,
Serializable {
    public static final String JavaURL = "java:";
    private static final int JavaURLLength = 5;
    private Hashtable _env = new Hashtable();

    public JavaContext() throws NamingException {
        this._env = new Hashtable();
    }

    public JavaContext(Hashtable hashtable) throws NamingException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addToEnvironment(string, hashtable.get(string));
            }
        } else {
            this._env = new Hashtable();
        }
    }

    public Object lookup(String string) throws NamingException {
        if (!string.startsWith(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.lookup(string.substring(5));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty() || !name.get(0).equals(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.lookup(name.getSuffix(1));
    }

    public Object lookupLink(String string) throws NamingException {
        if (!string.startsWith(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.lookupLink(string.substring(5));
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name.isEmpty() || !name.get(0).equals(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.lookupLink(name.getSuffix(1));
    }

    public void bind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rebind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rename(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (!string.startsWith(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.list(string.substring(5));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty() || !name.get(0).equals(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.list(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (!string.startsWith(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.listBindings(string.substring(5));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty() || !name.get(0).equals(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.listBindings(name.getSuffix(1));
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (!string.startsWith(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.getNameParser(string.substring(5));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name.isEmpty() || !name.get(0).equals(JavaURL)) {
            throw new NamingException("Internal error: context not accessed as java JavaURL");
        }
        EnvContext envContext = new EnvContext(this._env);
        return envContext.getNameParser(name.getSuffix(1));
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name2.clone();
        return name2.addAll(name);
    }

    public String composeName(String string, String string2) {
        return string2 + "/" + string;
    }

    public String getNameInNamespace() throws NamingException {
        return JavaURL;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this._env.put(string, object);
    }

    public Hashtable getEnvironment() {
        return this._env;
    }

    public Object removeFromEnvironment(String string) {
        return this._env.remove(string);
    }

    public void close() {
        this._env = null;
    }

    public String toString() {
        return JavaURL;
    }
}

