/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.xid;

import javax.transaction.xa.Xid;
import tyrex.services.UUID;
import tyrex.tm.xid.BaseXid;
import tyrex.tm.xid.BranchXid;
import tyrex.tm.xid.ExternalXid;
import tyrex.tm.xid.GlobalXid;
import tyrex.tm.xid.InvalidXidException;
import tyrex.tm.xid.LocalXid;
import tyrex.util.Messages;

public final class XidUtils {
    public static final String XID_PREFIX = "xid:";
    public static final int FORMAT_ID = 14745550;
    protected static final byte[] EMPTY_ARRAY = new byte[0];
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Xid newLocal() {
        return new LocalXid();
    }

    public static Xid newGlobal() {
        return new GlobalXid();
    }

    public static Xid importXid(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (xid instanceof BaseXid) {
            return xid;
        }
        return new ExternalXid(xid);
    }

    public static Xid importXid(int n, byte[] byArray, byte[] byArray2) {
        return new ExternalXid(n, byArray, byArray2);
    }

    public static Xid newBranch(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (xid instanceof BaseXid) {
            return ((BaseXid)xid).newBranch();
        }
        return new ExternalXid(xid.getFormatId(), xid.getGlobalTransactionId(), UUID.createBinary());
    }

    public static boolean isLocal(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (xid instanceof LocalXid) {
            return true;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        return byArray == null || byArray.length == 0;
    }

    public static boolean isGlobal(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (xid instanceof GlobalXid || xid instanceof BranchXid) {
            return true;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        return byArray != null && byArray.length != 0;
    }

    public static boolean isBranch(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (xid instanceof LocalXid || xid instanceof BranchXid) {
            return true;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        return byArray == null || byArray.length == 0;
    }

    public static String toString(Xid xid) {
        int n;
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        if (xid instanceof BaseXid) {
            return xid.toString();
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XID_PREFIX);
        stringBuffer.append(HEX_DIGITS[n2 >> 28 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 >> 24 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 >> 20 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 >> 16 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 >> 12 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 >> 8 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 >> 4 & 0xF]);
        stringBuffer.append(HEX_DIGITS[n2 & 0xF]);
        stringBuffer.append('-');
        if (byArray != null && byArray.length > 0) {
            n = byArray.length;
            while (n-- > 0) {
                stringBuffer.append(HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
                stringBuffer.append(HEX_DIGITS[byArray[n] & 0xF]);
            }
        }
        if (byArray2 != null && byArray2.length > 0) {
            stringBuffer.append('-');
            n = byArray2.length;
            while (n-- > 0) {
                stringBuffer.append(HEX_DIGITS[(byArray2[n] & 0xF0) >> 4]);
                stringBuffer.append(HEX_DIGITS[byArray2[n] & 0xF]);
            }
        }
        return stringBuffer.toString();
    }

    public static Xid parse(String string) throws InvalidXidException {
        byte[] byArray;
        int n;
        byte[] byArray2;
        char c;
        char c2;
        if (string == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        if (!string.startsWith(XID_PREFIX)) {
            throw new InvalidXidException(Messages.format("tyrex.util.idInvalidPrefix", XID_PREFIX, string));
        }
        int n2 = XID_PREFIX.length();
        int n3 = string.length();
        int n4 = 0;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            ++n2;
            if (c2 == '-') break;
            if (n2 == n3) {
                throw new InvalidXidException(Messages.format("tyrex.util.idInvalidOddDigits", string));
            }
            c = string.charAt(n2);
            ++n2;
            n4 = (n4 << 8) + XidUtils.getByte(c2, c, string);
        }
        if (n4 == -1) {
            throw new InvalidXidException("Null transaction identifier is invalid");
        }
        if (n2 == n3) {
            throw new InvalidXidException("Transaction identifier missing global transaction identifier");
        }
        byte[] byArray3 = new byte[64];
        int n5 = 0;
        while (n2 < n3) {
            if (n5 == 64) {
                throw new InvalidXidException("Transaction identifier exceeding maximum length allowed");
            }
            c2 = string.charAt(n2);
            ++n2;
            if (c2 == '-') break;
            if (n2 == n3) {
                throw new InvalidXidException(Messages.format("tyrex.util.idInvalidOddDigits", string));
            }
            c = string.charAt(n2);
            ++n2;
            byArray3[n5] = XidUtils.getByte(c2, c, string);
            ++n5;
        }
        if (n5 == 64) {
            byArray2 = byArray3;
        } else if (n5 == 0) {
            byArray2 = EMPTY_ARRAY;
        } else {
            byArray2 = new byte[n5];
            n = n5;
            while (n-- > 0) {
                byArray2[n] = byArray3[n];
            }
        }
        if (n2 == n3) {
            byArray = EMPTY_ARRAY;
        } else {
            byArray3 = new byte[64];
            n5 = 0;
            while (n2 < n3) {
                if (n5 == 64) {
                    throw new InvalidXidException("Branch qualifier exceeding maximum length allowed");
                }
                c2 = string.charAt(n2);
                ++n2;
                if (c2 == '-') break;
                if (n2 == n3) {
                    throw new InvalidXidException(Messages.format("tyrex.util.idInvalidOddDigits", string));
                }
                c = string.charAt(n2);
                ++n2;
                byArray3[n5] = XidUtils.getByte(c2, c, string);
                ++n5;
            }
            if (n5 == 64) {
                byArray = byArray3;
            } else if (n5 == 0) {
                byArray = EMPTY_ARRAY;
            } else {
                byArray = new byte[n5];
                n = n5;
                while (n-- > 0) {
                    byArray[n] = byArray3[n];
                }
            }
        }
        if (n4 == -2132738098 && byArray2 == EMPTY_ARRAY && byArray != EMPTY_ARRAY) {
            return new LocalXid(string, byArray);
        }
        if (n4 == 14745550 && byArray2 != EMPTY_ARRAY) {
            if (byArray == EMPTY_ARRAY) {
                return new GlobalXid(string, byArray2);
            }
            return new BranchXid(string, byArray2, byArray);
        }
        return new ExternalXid(string, n4, byArray2, byArray);
    }

    private static byte getByte(char c, char c2, String string) throws InvalidXidException {
        byte by;
        if (c >= '0' && c <= '9') {
            by = (byte)(c - 48 << 4);
        } else if (c >= 'A' && c <= 'F') {
            by = (byte)(c - 55 << 4);
        } else if (c >= 'a' && c <= 'f') {
            by = (byte)(c - 87 << 4);
        } else {
            throw new InvalidXidException(Messages.format("tyrex.util.idInvalidCharacter", String.valueOf(c), string));
        }
        if (c2 >= '0' && c2 <= '9') {
            by = (byte)(by | c2 - 48);
        } else if (c2 >= 'A' && c2 <= 'F') {
            by = (byte)(by | c2 - 55);
        } else if (c2 >= 'a' && c2 <= 'f') {
            by = (byte)(by | c2 - 87);
        } else {
            throw new InvalidXidException(Messages.format("tyrex.util.idInvalidCharacter", String.valueOf(c2), string));
        }
        return by;
    }
}

