package controllers
import play.api._
import play.api.i18n._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._
import forms._
import models._
import models.services._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
object ProjectController extends Controller{
  val Home = Redirect(routes.ProjectController.list(0,""))
  val projectRegistForm = Form(
      mapping(
          "name" -> nonEmptyText,
          "users" -> mapping(
              "name" -> text
              )(UserForm.apply)(UserForm.unapply)
          )(ProjectForm.apply)(ProjectForm.unapply)
      )
      
	def createProject = AuthAction {
    Action { implicit request =>
      if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
      } else {
        var logInUser = UserForm("")
        request.headers.get("remote_user").map { user =>
          logInUser = UserForm(user)
          }
        Ok(views.html.createProjectForm(projectRegistForm.fill(ProjectForm("", logInUser))))
      }
	}
  }
  
  	def projectRegistration() = Action {implicit request =>
  	  projectRegistForm.bindFromRequest.fold(
  	      formWithErrors => BadRequest(views.html.createProjectForm(formWithErrors)),
//	      formWithErrors => BadRequest(views.html.error(formWithErrors)),
  	      project => {
  	        inTransaction {
  	          val user = UserManager().getByName(project.users.name)
  	          val newProject = ProjectManager().insert(project)
  	          newProject.users.associate(user)
  	    	   Home.flashing("success" -> "Project %s has been created".format(project.name))
  	        }
  	      }
  	  )
  	 }
  	
  	def updateProject(id: Long) = AuthAction {
  	  Action { implicit request =>
  	    if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
  	    } else {
  	      inTransaction {
  	        val project = ProjectManager().getById(id)
  	        val projectForm = ProjectForm(project.name, null)
  	        Ok(views.html.updateProjectForm(projectRegistForm.fill(projectForm), id, project))
  	        }
  	      }
  	  }
  	}
  	
  	def projectModification(id: Long) = Action { implicit request =>
  	  projectRegistForm.bindFromRequest.fold(
  	      formWithErrors => BadRequest(views.html.updateProjectForm(formWithErrors, id, null)),
  	      project => {
  	        inTransaction {
  	          ProjectManager().update(project, id)
  	          Home.flashing("success" -> "Project %s has been update".format(project.name))
  	        }
  	      }
  	  )
  	}
  	
  	def projectMemberDelete(projectId:Long, memberId:Long) = AuthAction {
  	  Action {implicit request =>
  	    if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
  	    } else {  
  	      inTransaction {
  	        ProjectManager().deleteMember(projectId, memberId)
  	        Home.flashing("success" -> "Project %s has been update".format("ID=" +memberId))
  	       }
  	     }
  	  }
  	}
  	
  	def list(page: Int, key: String) = AuthAction {
  	  Action{ implicit request =>
  	    if(request == null) {
    		Ok(views.html.errors.errorNotAuthentication())      
  	    } else {
  	      inTransaction {
  	        val row = Integer.decode(Messages("list.row"))
  	        val buff = ProjectManager().list(key)
  	        Ok(views.html.projectlist(buff.page(page*row, row), buff.size, key, page))
  	      }
  	    }
  	  }
  	}
}