package controllers.services
import scala.collection.mutable.ArrayBuffer
import scala.collection.mutable.HashMap
import beans._
import models._
import models.services._
case class PartsList() {
	def getPartsBuffer(opt:Int, page:Int, key:String, relationKey:String):ArrayBuffer[PartsListShowBean] = {
		var partsBuffer = ArrayBuffer[PartsListShowBean]()
		val targetParts = PartManager().getByName(key)
		if(targetParts.size != 0) {
		  for(returnPartBuffer <- PartRecursion().down(PartManager().getByName(key).head, 1, opt, relationKey)) {
		    partsBuffer += returnPartBuffer
		  }
		}
		return partsBuffer
	}
	
	def getMatrixPartsList(partsListBeans: ArrayBuffer[ArrayBuffer[PartsListShowBean]], allChildren: ArrayBuffer[Part]): HashMap[Part, ArrayBuffer[MultiPartsListBean]] = {
	  var matrixPartsListBeans = HashMap[Part, ArrayBuffer[MultiPartsListBean]]()
      // 抽出した各モデル毎の部品表配列に対し、部品の有無をチェエク
     for(partsListBean <- partsListBeans) {
         var allChildrenList = ArrayBuffer[MultiPartsListBean]()
          // 全ての部品一覧作成
         for(child <- allChildren.distinct.sortBy(p => p.name)) {
           allChildrenList += MultiPartsListBean(child, 1)
          }
          // 比較対象モデルの部品一覧作成
         var targetChildren = ArrayBuffer[MultiPartsListBean]()
         for(targetChildlist <- partsListBean) {
           targetChildren += MultiPartsListBean(targetChildlist.child, 1)
          }
          // 全ての部品一覧の各部品が、比較対象モデルの部品一覧に存在するかチェック。
         if(partsListBean.size !=0 ) {
        	 for(compare <- allChildrenList) {
	  			if(!targetChildren.contains(compare)) {
               //存在しない場合、表示をOff
             		val position:Int = allChildrenList.indexOf(compare)
             		allChildrenList(position).showOn = 0
	  			}
             }
        	 // 表示制御済みの部品表配列を蓄積
        	 matrixPartsListBeans.put(PartManager().getByName(partsListBean.head.parent).head, allChildrenList)
           } else {
             for(allChild <- allChildrenList) {
               allChild.showOn = 0
               }
               // 表示制御済みの部品表配列を蓄積
             matrixPartsListBeans.put(null, allChildrenList)
             }
     	}
	   return matrixPartsListBeans
	}
}