package controllers
import play.api._
import play.api.mvc._
import play.api.libs.json._
import play.api.libs.functional.syntax._
import beans._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.collection.mutable.ArrayBuffer

object Autocomplete extends Controller{

  def projectList() = Action {
    request => {
      var projectList:String=""
      inTransaction {
	    val projects =PartsListDb.projects.where(p => p.name like request.getQueryString("q").get + "%")
	    for(project <- projects) {
	      projectList = projectList.concat(project.name)
	      projectList = projectList.concat("\n")
	    }
	  }
    Ok(projectList)
	}
  }
  
  def partList() = Action {
    request => {
      var partList:String = ""
       inTransaction {
        val parts = PartsListDb.parts.where(p => p.name like request.getQueryString("q").get + "%")
        for(part <- parts) {
          partList = partList.concat(part.name)
          partList = partList.concat("\n")
        }
      }
      Ok(partList)
    }
  }
  
  def userList() = Action {
    request => {
      var userList:String = ""
       inTransaction {
        val users = PartsListDb.users.where(u => u.name like request.getQueryString("q").get + "%")
        for(user <- users) {
          userList = userList.concat(user.name)
          userList = userList.concat("\n")
        }
      }
      Ok(userList)
    }
  }

}