package models
import play.api.test._
import play.api.test.Helpers._
import org.specs2.mutable.Specification
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import org.squeryl.dsl._
import org.squeryl.dsl.ast._
import beans._
import scala.collection.immutable.Spec
class PartSpec extends Specification{
  "Part" should {
    "create new Part" in {
      running(FakeApplication()) {
        inTransaction {
           // データ登録
          val project = PartsListDb.projects.insert(Project("S1_pro"))

          val parentPart1:Part = PartsListDb.parts.insert(Part("Model1", null, 0, 1))
          val parentPart2:Part = PartsListDb.parts.insert(Part("Model2", null, 0, 1))
          val childPart1:Part = PartsListDb.parts.insert(Part("Unit1", null, 0, 1))
          val childPart2:Part = PartsListDb.parts.insert(Part("Unit2", null, 0, 1))
          val childPart3:Part = PartsListDb.parts.insert(Part("Unit3", null, 0, 1))
          val grandChildPart1:Part = PartsListDb.parts.insert(Part("Part1", null, 0, 1))
          val grandChildPart2:Part = PartsListDb.parts.insert(Part("Part2", null, 0, 1))
          val grandChildPart3:Part = PartsListDb.parts.insert(Part("Part3", null, 0, 1))
          val grandChildPart4:Part = PartsListDb.parts.insert(Part("Part4", null, 0, 1))
          val grandChildPart5:Part = PartsListDb.parts.insert(Part("Part5", null, 0, 1))
          
          parentPart1.parts.associate(childPart1)
          var pr = parentPart1.parts.assign(childPart1)
          pr.quantity = 1L
          PartsListDb.partRelations.update(pr)

          parentPart1.parts.associate(childPart2)
          pr = parentPart1.parts.assign(childPart2)
          pr.quantity = 2L
          PartsListDb.partRelations.update(pr)

          parentPart2.parts.associate(childPart2)
          pr = parentPart2.parts.assign(childPart2)
          pr.quantity = 3L
          PartsListDb.partRelations.update(pr)

          parentPart2.parts.associate(grandChildPart2)
          pr = parentPart2.parts.assign(grandChildPart2)
          pr.quantity = 4L
          PartsListDb.partRelations.update(pr)

          childPart1.parts.associate(grandChildPart1)
          pr = childPart1.parts.assign(grandChildPart1)
          pr.quantity = 5L
          PartsListDb.partRelations.update(pr)

          childPart1.parts.associate(grandChildPart2)
          pr = childPart1.parts.assign(grandChildPart2)
          pr.quantity = 6L
          PartsListDb.partRelations.update(pr)

          childPart2.parts.associate(grandChildPart1)
          pr = childPart2.parts.assign(grandChildPart1)
          pr.quantity = 7L
          PartsListDb.partRelations.update(pr)

          childPart2.parts.associate(grandChildPart3)
          pr = childPart2.parts.assign(grandChildPart3)
          pr.quantity = 8L
          PartsListDb.partRelations.update(pr)

          childPart2.parts.associate(childPart3)
          pr = childPart2.parts.assign(childPart3)
          pr.quantity = 9L
          PartsListDb.partRelations.update(pr)
          
          grandChildPart1.parts.associate(grandChildPart4)
          pr = grandChildPart1.parts.assign(grandChildPart4)
          pr.quantity = 11L
          PartsListDb.partRelations.update(pr)
         
          childPart3.parts.associate(grandChildPart5)
           // partの総件数をチェック。
          PartsListDb.parts.size must beEqualTo (10)
          pr = childPart3.parts.assign(grandChildPart5)
          pr.quantity = 10L
          PartsListDb.partRelations.update(pr)
           // updateの結果を確認。
          childPart3.partRelation(grandChildPart5.id).quantity must beEqualTo (10L)
          
          var buffer = ArrayBuffer[PartsListBean]()
          
          val atach1 = PartsListDb.atachs.insert(Atach("image/jpeg", "accept.jpg", "AAA", 10))
          grandChildPart5.atachs.associate(atach1)
          grandChildPart5.atachs.head.contentType must beEqualTo("image/jpeg")

          project.parts.associate(parentPart1)
          project.name must beEqualTo("S1_pro")
                   
          atach1.part.assign(atach1.part.head).name must beEqualTo("Part5")
          parentPart1.project.assign(parentPart1.project.head).name must beEqualTo("S1_pro")
                    
          val user = PartsListDb.users.insert(User("uyaji", "uyaji.mail.com"))
          user.name must beEqualTo("uyaji")
          
          project.users.associate(user)
          project.users.head.name must beEqualTo ("uyaji")
          
/*          project.members.associate(user)
          project.members.size must beEqualTo (1)*/
          
          for(model <- PartsListDb.parts.where(p => p.name like "M%")) {
//          for(model <- PartsListDb.parts) {
            Recursion(model, 0, buffer)
            println("------------------------------------------------------------")
            }
          for(tmpPart <- buffer) {
            println("parent = " + tmpPart.parent + " - child = " + tmpPart.child)
          }
            println("------------------------------------------------------------")
          for(tmpPart <- buffer.drop(3).take(5)) {
            println("parent = " + tmpPart.parent + " - child = " + tmpPart.child)
          }
        }
      }
    }
  }
  def Recursion(parentPart:Part, value:Int, var buffer:Seq[PartsListBean]):Unit = {
    val level:Int = value +1
    for(child <- parentPart.parts) {
      println("Child Part(" + level + ")      =  " + parentPart.name + " - " + child.name)
      buffer = buffer.:+(PartsListBean(parentPart.name, child.name, parentPart.partRelation(child.id).quantity, parentPart.partRelation(child.id).relationKey))
      Recursion(child, level, buffer)
     }
  }
}