/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.util.Timeout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import play.api.libs.concurrent.PlayPromise;
import play.core.Invoker;
import play.core.Invoker$;
import play.core.j.EitherToFEither;
import play.core.j.JavaPromise;
import play.mvc.Http;
import scala.Function1;
import scala.Unit;
import scala.concurrent.Future;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public class F {
    public static <A> Some<A> Some(A a) {
        return new Some<A>(a);
    }

    public static None None() {
        return new None();
    }

    public static <A, B> Tuple<A, B> Tuple(A a, B b) {
        return new Tuple<A, B>(a, b);
    }

    public static <A, B, C> Tuple3<A, B, C> Tuple3(A a, B b, C c) {
        return new Tuple3<A, B, C>(a, b, c);
    }

    public static <A, B, C, D> Tuple4<A, B, C, D> Tuple4(A a, B b, C c, D d) {
        return new Tuple4<A, B, C, D>(a, b, c, d);
    }

    public static <A, B, C, D, E> Tuple5<A, B, C, D, E> Tuple5(A a, B b, C c, D d, E e) {
        return new Tuple5<A, B, C, D, E>(a, b, c, d, e);
    }

    public static class Tuple5<A, B, C, D, E> {
        public final A _1;
        public final B _2;
        public final C _3;
        public final D _4;
        public final E _5;

        public Tuple5(A a, B b, C c, D d, E e) {
            this._1 = a;
            this._2 = b;
            this._3 = c;
            this._4 = d;
            this._5 = e;
        }

        public String toString() {
            return "Tuple5(_1: " + this._1 + ", _2: " + this._2 + ", _3:" + this._3 + ", _4:" + this._4 + ", _5:" + this._5 + ")";
        }
    }

    public static class Tuple4<A, B, C, D> {
        public final A _1;
        public final B _2;
        public final C _3;
        public final D _4;

        public Tuple4(A a, B b, C c, D d) {
            this._1 = a;
            this._2 = b;
            this._3 = c;
            this._4 = d;
        }

        public String toString() {
            return "Tuple4(_1: " + this._1 + ", _2: " + this._2 + ", _3:" + this._3 + ", _4:" + this._4 + ")";
        }
    }

    public static class Tuple3<A, B, C> {
        public final A _1;
        public final B _2;
        public final C _3;

        public Tuple3(A a, B b, C c) {
            this._1 = a;
            this._2 = b;
            this._3 = c;
        }

        public String toString() {
            return "Tuple3(_1: " + this._1 + ", _2: " + this._2 + ", _3:" + this._3 + ")";
        }
    }

    public static class Tuple<A, B> {
        public final A _1;
        public final B _2;

        public Tuple(A a, B b) {
            this._1 = a;
            this._2 = b;
        }

        public String toString() {
            return "Tuple2(_1: " + this._1 + ", _2: " + this._2 + ")";
        }
    }

    public static class Either<A, B> {
        public final Option<A> left;
        public final Option<B> right;

        private Either(Option<A> option, Option<B> option2) {
            this.left = option;
            this.right = option2;
        }

        public static <A, B> Either<A, B> Left(A a) {
            return new Either<A, B>(F.Some(a), F.None());
        }

        public static <A, B> Either<A, B> Right(B b) {
            return new Either<A, B>(F.None(), F.Some(b));
        }

        public String toString() {
            return "Either(left: " + this.left + ", right: " + this.right + ")";
        }
    }

    public static class Some<T>
    extends Option<T> {
        final T value;

        public Some(T t) {
            this.value = t;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singletonList(this.value).iterator();
        }

        public String toString() {
            return "Some(" + this.value + ")";
        }
    }

    public static class None<T>
    extends Option<T> {
        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalStateException("No value");
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptyList().iterator();
        }

        public String toString() {
            return "None";
        }
    }

    public static abstract class Option<T>
    implements Iterable<T> {
        public abstract boolean isDefined();

        public abstract T get();

        public static <T> None<T> None() {
            return new None();
        }

        public static <T> Some<T> Some(T t) {
            return new Some<T>(t);
        }

        public T getOrElse(T t) {
            if (this.isDefined()) {
                return this.get();
            }
            return t;
        }

        public <A> Option<A> map(Function<T, A> function) {
            if (this.isDefined()) {
                try {
                    return Option.Some(function.apply(this.get()));
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            return Option.None();
        }
    }

    public static class Promise<A> {
        private final Future<A> promise;
        static Integer nb = 64;
        static List<ActorRef> actors = null;

        public Promise(Future<A> future) {
            this.promise = future;
        }

        public static void resetActors() {
            actors = null;
        }

        public static <A> Promise<List<A>> sequence(Promise<? extends A> ... promiseArray) {
            return new Promise<List<A>>(JavaPromise.sequence(Arrays.asList(promiseArray)));
        }

        @Deprecated
        public static <A> Promise<List<A>> waitAll(Promise<? extends A> ... promiseArray) {
            return Promise.sequence(promiseArray);
        }

        public static <A> Promise<A> timeout(A a, Long l, TimeUnit timeUnit) {
            return new Promise<A>(JavaPromise.timeout(a, l, timeUnit));
        }

        public static Promise<Unit> timeout() throws TimeoutException {
            return new Promise<Nothing$>(JavaPromise.timeout());
        }

        public static <A> Promise<A> timeout(A a, Long l) {
            return Promise.timeout(a, l, TimeUnit.MILLISECONDS);
        }

        public static <A> Promise<List<A>> sequence(Iterable<Promise<? extends A>> iterable) {
            ArrayList arrayList = new ArrayList();
            for (Promise<A> promise : iterable) {
                arrayList.add(promise);
            }
            return new Promise<List<A>>(JavaPromise.sequence(arrayList));
        }

        @Deprecated
        public static <A> Promise<List<A>> waitAll(Iterable<Promise<? extends A>> iterable) {
            return Promise.sequence(iterable);
        }

        public static <A> Promise<A> pure(A a) {
            return new Promise<A>(JavaPromise.pure(a));
        }

        public static <A> Promise<A> throwing(Throwable throwable) {
            return new Promise(JavaPromise.throwing(throwable));
        }

        public A get() {
            return new PlayPromise<A>(this.promise).value1().get();
        }

        public A get(Long l, TimeUnit timeUnit) {
            return new PlayPromise<A>(this.promise).await(l, timeUnit).get();
        }

        public A get(Long l) {
            return this.get(l, TimeUnit.MILLISECONDS);
        }

        public <B> Promise<Either<A, B>> or(Promise<B> promise) {
            return new Promise(new PlayPromise<A>(this.promise).or(promise.getWrappedPromise())).map(new EitherToFEither());
        }

        public void onRedeem(final Callback<A> callback) {
            final Http.Context context = Http.Context.current.get();
            new PlayPromise<A>(this.promise).onRedeem((Function1<A, BoxedUnit>)new AbstractFunction1<A, BoxedUnit>(){

                public BoxedUnit apply(A a) {
                    try {
                        Promise.run(new Function<A, Object>(){

                            @Override
                            public Object apply(A a) {
                                try {
                                    callback.invoke(a);
                                    return 0;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw runtimeException;
                                }
                                catch (Throwable throwable) {
                                    throw new RuntimeException(throwable);
                                }
                            }
                        }, a, context);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            }, Invoker.executionContext());
        }

        public <B> Promise<B> map(final Function<A, B> function) {
            final Http.Context context = Http.Context.current.get();
            return new Promise<A>(this.promise.flatMap((Function1)new AbstractFunction1<A, Future<B>>(){

                public Future<B> apply(A a) {
                    try {
                        return Promise.run(function, a, context);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }, Invoker.executionContext()));
        }

        public Promise<A> recover(final Function<Throwable, A> function) {
            final Http.Context context = Http.Context.current.get();
            return new Promise<A>(JavaPromise.recover(this.promise, new AbstractFunction1<Throwable, Future<A>>(){

                public Future<A> apply(Throwable throwable) {
                    try {
                        return Promise.run(function, throwable, context);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable2) {
                        throw new RuntimeException(throwable2);
                    }
                }
            }, Invoker.executionContext()));
        }

        public <B> Promise<B> flatMap(final Function<A, Promise<B>> function) {
            final Http.Context context = Http.Context.current.get();
            return new Promise<A>(this.promise.flatMap((Function1)new AbstractFunction1<A, Future<Promise<B>>>(){

                public Future<Promise<B>> apply(A a) {
                    try {
                        return Promise.run(function, a, context);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }, Invoker.executionContext()).flatMap((Function1)new AbstractFunction1<Promise<B>, Future<B>>(){

                public Future<B> apply(Promise<B> promise) {
                    return promise.promise;
                }
            }, Invoker.executionContext()));
        }

        public Future<A> getWrappedPromise() {
            return this.promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static List<ActorRef> actors() {
            Class<Promise> clazz = Promise.class;
            synchronized (Promise.class) {
                if (actors != null) return actors;
                Class<Promise> clazz2 = Promise.class;
                synchronized (Promise.class) {
                    actors = new ArrayList<ActorRef>(nb);
                    for (int i = 0; i < nb; ++i) {
                        actors.add(Invoker$.MODULE$.system().actorOf(new Props(PromiseActor.class), "promise-actor-" + i));
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return actors;
                }
            }
        }

        static <A, B> Future<B> run(Function<A, B> function, A a, Http.Context context) {
            Long l = context == null ? Long.valueOf(0L) : context.id();
            return JavaPromise.akkaAsk(Promise.actors().get((int)(l % (long)Promise.actors().size())), F.Tuple3(function, a, context), Timeout.apply((long)3600000L)).map((Function1)new AbstractFunction1<Object, B>(){

                public B apply(Object object) {
                    Either either = (Either)object;
                    if (either.left.isDefined()) {
                        Throwable throwable = (Throwable)either.left.get();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new RuntimeException(throwable);
                    }
                    return either.right.get();
                }
            }, Invoker.executionContext());
        }

        public static class PromiseActor
        extends UntypedActor {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Object object) {
                Function function = (Function)((Tuple3)object)._1;
                Object b = ((Tuple3)object)._2;
                Http.Context context = (Http.Context)((Tuple3)object)._3;
                try {
                    Http.Context.current.set(context);
                    this.getSender().tell(Either.Right(function.apply(b)));
                }
                catch (Throwable throwable) {
                    this.getSender().tell(Either.Left(throwable));
                }
                finally {
                    Http.Context.current.remove();
                }
            }
        }
    }

    public static interface Function3<A, B, C, R> {
        public R apply(A var1, B var2, C var3) throws Throwable;
    }

    public static interface Function2<A, B, R> {
        public R apply(A var1, B var2) throws Throwable;
    }

    public static interface Function<A, R> {
        public R apply(A var1) throws Throwable;
    }

    public static interface Function0<R> {
        public R apply() throws Throwable;
    }

    public static interface Callback3<A, B, C> {
        public void invoke(A var1, B var2, C var3) throws Throwable;
    }

    public static interface Callback2<A, B> {
        public void invoke(A var1, B var2) throws Throwable;
    }

    public static interface Callback<A> {
        public void invoke(A var1) throws Throwable;
    }

    public static interface Callback0 {
        public void invoke() throws Throwable;
    }
}

