/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Category;
import tyrex.resource.PoolLimits;
import tyrex.resource.PoolMetrics;
import tyrex.resource.Resource;
import tyrex.resource.ResourceConfig;
import tyrex.resource.ResourceException;
import tyrex.resource.jdbc.ConnectionPool;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TyrexTransactionManager;
import tyrex.util.Logger;

public class DataSourceConfig
extends ResourceConfig {
    private String _className;
    private Resource _resource;
    private ClassLoader _classLoader;

    public void setClassName(String string) {
        this._className = string;
    }

    public String getClassName() {
        return this._className;
    }

    public Object createFactory() throws ResourceException {
        try {
            return this.createFactory_();
        }
        catch (ResourceException resourceException) {
            Logger.resource.error((Object)("Error in datasource configuration '" + this.getName() + "'"), (Throwable)resourceException);
            throw resourceException;
        }
    }

    private Object createFactory_() throws ResourceException {
        Object obj;
        String string = this._name;
        String string2 = this._jar;
        String string3 = this._className;
        String string4 = this._paths;
        if (string == null || string.trim().length() == 0) {
            throw new ResourceException("The configuration element is missing the resource manager name");
        }
        if (string3 == null || string3.trim().length() == 0) {
            throw new ResourceException("The configuration element is missing the data source class name");
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            if (string2 != null && string2.trim().length() > 0) {
                arrayList.add(this.getURL(string2));
            }
            if (string4 != null && string4.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",; ");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    arrayList.add(this.getURL(string2));
                }
            }
        }
        catch (IOException iOException) {
            Logger.resource.error((Object)("Could not create url for datasource file: '" + string2 + "'. File may not exist."));
            throw new ResourceException(iOException);
        }
        this._classLoader = arrayList.size() > 0 ? new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), this.getClass().getClassLoader()) : this.getClass().getClassLoader();
        try {
            Class<?> clazz = this._classLoader.loadClass(string3);
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ResourceException(exception);
        }
        if (obj instanceof DataSource || obj instanceof XADataSource || obj instanceof ConnectionPoolDataSource) {
            return obj;
        }
        throw new ResourceException("Data source is not of type DataSource, XADataSource or ConnectionPoolDataSource");
    }

    public synchronized Resource createResource(TransactionDomain transactionDomain) throws ResourceException {
        String string = this._name;
        if (string == null || string.trim().length() == 0) {
            throw new ResourceException("The configuration element is missing the resource manager name");
        }
        if (transactionDomain == null) {
            throw new ResourceException("The configuration was not loaded from a transaction domain");
        }
        TyrexTransactionManager tyrexTransactionManager = (TyrexTransactionManager)transactionDomain.getTransactionManager();
        if (this._resource != null) {
            return this._resource;
        }
        Object object = this._factory;
        if (object == null) {
            throw new ResourceException("No data source configured");
        }
        if (object instanceof XADataSource) {
            this._resource = new ConnectionPool(string, super.getLimits(), this._classLoader, (XADataSource)object, null, tyrexTransactionManager, Category.getInstance((String)(Logger.resource.getName() + "." + string)));
            return this._resource;
        }
        if (object instanceof ConnectionPoolDataSource) {
            this._resource = new ConnectionPool(string, super.getLimits(), this._classLoader, null, (ConnectionPoolDataSource)object, tyrexTransactionManager, Category.getInstance((String)(Logger.resource.getName() + "." + string)));
            return this._resource;
        }
        if (object instanceof DataSource) {
            this._resource = new DataSourceResource((DataSource)object);
            return this._resource;
        }
        throw new ResourceException("Data source is not of type DataSource, XADataSource or ConnectionPoolDataSource");
    }

    private static final class DataSourceResource
    implements Resource {
        private final PoolMetrics _metrics = new PoolMetrics();
        private final DataSource _dataSource;
        private final PoolLimits _limits;
        static /* synthetic */ Class class$javax$sql$DataSource;

        DataSourceResource(DataSource dataSource) {
            this._dataSource = dataSource;
            this._limits = new PoolLimits();
        }

        public PoolMetrics getPoolMetrics() {
            return this._metrics;
        }

        public Object getClientFactory() {
            return this._dataSource;
        }

        public Class getClientFactoryClass() {
            return class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = DataSourceResource.class$("javax.sql.DataSource")) : class$javax$sql$DataSource;
        }

        public XAResource getXAResource() {
            return null;
        }

        public PoolLimits getPoolLimits() {
            return this._limits;
        }

        public void destroy() {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

