/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private Table table;
    private Sequence sequence;
    private Expression start;
    private Expression increment;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null) {
            throw DbException.get(90036, column.getSQL());
        }
    }

    public void setStartWith(Expression expression) {
        this.start = expression;
    }

    public void setIncrement(Expression expression) {
        this.increment = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        Session session;
        long l;
        Database database = this.session.getDatabase();
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if (this.start != null) {
            l = this.start.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setStartValue(l);
        }
        if (this.increment != null) {
            l = this.increment.optimize(this.session).getValue(this.session).getLong();
            if (l == 0L) {
                throw DbException.getInvalidValueException("INCREMENT", 0);
            }
            this.sequence.setIncrement(l);
        }
        Session session2 = session = database.getSystemSession();
        synchronized (session2) {
            database.update(session, this.sequence);
            session.commit(true);
        }
        return 0;
    }

    public int getType() {
        return 54;
    }
}

