package controllers

import mvc.AuthAction
import play.api._
import play.api.mvc._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import models.services._

object AtachController extends Controller{

  val Home = Redirect(routes.PartsMasterController.list(0,""))

  def showAtach(id:Long) = AuthAction {
    Action {implicit request =>
      if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
      } else {
        inTransaction {
          Ok(AtachManager().showAtach(id)).as(AtachManager().getById(id).contentType)
          }
        }
      }
    }
  
  def dropAtach(id:Long) = AuthAction {
    Action {implicit request =>
      if(request == null) {
        Ok(views.html.errors.errorNotAuthentication())        
      } else {
        inTransaction {
          AtachManager().delete(id)
          	Home.flashing("success" -> "Part %s has been created".format(id))
         }
      }
    }
  }

}