package controllers

import mvc.AuthAction
import play.api._
import play.api.i18n._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._
import java.io.FileInputStream
import forms._
import models.services._
import controllers.services._
import beans._
import services._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.io.Source
import java.io.File
import java.nio.file.Paths;
import java.nio.file.Files;

object PartsMasterController extends Controller{
   
   val Home = Redirect(routes.PartsMasterController.list(0,""))

   val partRegistForm = Form(
       mapping(
           "name" -> nonEmptyText,
           "atach" -> mapping(
               "grpName" -> text
             )(AtachForm.apply)(AtachForm.unapply),
           "projectName" -> nonEmptyText,
           "cost" -> longNumber
        )(PartForm.apply)(PartForm.unapply)
    )

    val csvRegistrationForm = Form(
        mapping(
            "grpName" -> text
        )(CsvForm.apply)(CsvForm.unapply)
    )

	def create = AuthAction {
     Action { implicit request =>
       if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
       } else {
         Ok(views.html.createPartForm(partRegistForm, ""))
       }
	 }
    }

	def partRegistration() = Action(parse.multipartFormData) { implicit request =>
	  partRegistForm.bindFromRequest.fold(
	      formWithErrors => BadRequest(views.html.createPartForm(formWithErrors, "")),
	      part => {
	        inTransaction {
	          if(PartManager().getByName(part.name).size == 0) {
	            val newPart = PartManager().insert(part)
	            request.body.file("atach").map { atach =>
	              AtachManager().uploadAtach(atach, atach.contentType.get, newPart.atach.grpName, newPart.id, 0, 0)
	              }
	            Home.flashing("success" -> "Part %s has been created".format(part.name))
	          } else {
	            Ok(views.html.createPartForm(partRegistForm.fill(PartForm(part.name, part.atach, part.projectName, part.price)), Messages("form.error2")))
	          }
	        }
	      }
	  )
	}

	def partRegistrationFromCsv() = Action(parse.multipartFormData) { implicit request =>
	  csvRegistrationForm.bindFromRequest.fold(
	      formWithErrors => BadRequest(views.html.partsmastershow(null, 0, "", 0)),
	      atach => {
	        inTransaction {
	          request.body.file("atach").map { csv =>
	            val file = csv.ref.file
	            val fis = new FileInputStream(file)
	            val src = Source.fromInputStream(fis)
	            val itr = src.getLines
	            for(it <- itr) {
	              if(it != "") {
	                val pb = CastBean().stringToBean(it, "beans.PartBean").asInstanceOf[PartBean]
	                val newPart = PartManager().insert(PartForm(pb.name, null, pb.projectName, pb.price))
	                if(!(pb.atach.equals(" "))) {
	                  AtachManager().uploadAtach(new File(pb.atach), Files.probeContentType(Paths.get(pb.atach)), "", newPart.id, 0, 0)
	                  }
	                }
	              }
	            }
	         }
	       }
	  )
     Home.flashing("success" -> "Csv has been created")
	}

	def update(id:Long) = AuthAction {
	  Action { implicit request =>
	    if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
	    } else {
	      inTransaction {
	        val part = PartManager().getById(id)
	        val partForm = PartForm(part.name, null, part.project.assign(part.project.head).name, part.price)
	        Ok(views.html.updatePartForm(partRegistForm.fill(partForm), id, part, ""))
	      }
	    }
	  }
	}

	def partModification(id:Long, partName:String) = Action(parse.multipartFormData) { implicit request =>
	  partRegistForm.bindFromRequest.fold(
	      formWithErrors => BadRequest(views.html.updatePartForm(formWithErrors, id , null, "")),
	      part => {
	        inTransaction {
	          if(part.name.equals(partName)) {
	            val updPart = PartManager().update(part, id)
	            request.body.file("atach").map { atach =>
	              AtachManager().uploadAtach(atach, atach.contentType.get, part.atach.grpName, updPart.id, 0, 0)
	              }
	            Home.flashing("success" -> "Part %s has been created".format(part.name))
	          } else {
	            // nameの変更の場合
	            if( PartManager().getByName(part.name).size != 0) {
    	             // 既存のnameへの変更であれば、エラー
	              val partForm = PartForm(part.name, null, part.projectName, part.price)
	              Ok(views.html.updatePartForm(partRegistForm.fill(partForm), id, PartManager().getByName(partName).head, Messages("form.error2")))
	            } else {
	              val updPart = PartManager().update(part, id)
	              request.body.file("atach").map { atach =>
	                AtachManager().uploadAtach(atach, atach.contentType.get, part.atach.grpName, updPart.id, 0, 0)
	                }
	              Home.flashing("success" -> "Part %s has been created".format(part.name))
	              }
	          }
	        }  
	      }
	  )
	}

	def partDelete(id:Long) = AuthAction {
	  Action {implicit request =>
	    if(request == null) {
         Ok(views.html.errors.errorNotAuthentication())
	    } else {
	      inTransaction {
	        PartManager().delete(id)
	        Home.flashing("success" -> "Part %s has been created".format(id))
	        }
	    }
	  }
	}
	
	def list(page:Int, key:String) = Action { implicit request =>
	  inTransaction {
		  val row = Integer.decode(Messages("list.row"))
		  val buff = PartManager().getByLikeName(key)
		  Ok(views.html.partsmastershow(buff.page(page*row, row), buff.size, key, page))
	  }
	}	
	
	def downLoad(key:String) = Action { implicit request =>
	  inTransaction {
		  val row = Integer.decode(Messages("list.row"))
		  val buff = PartManager().getByLikeName(key)
		  val attachment = "attachment; filename=parts_master_download.csv"
		  Ok(views.html.partsmastercsv(buff)).withHeaders(CONTENT_DISPOSITION -> attachment).as("text/csv")
	  }
	}	
}