# $OpenBSD: MKcaptab.awk,v 1.4 2010/01/12 23:22:06 nicm Exp $
##############################################################################
# Copyright (c) 1998-2006,2007 Free Software Foundation, Inc.                #
#                                                                            #
# Permission is hereby granted, free of charge, to any person obtaining a    #
# copy of this software and associated documentation files (the "Software"), #
# to deal in the Software without restriction, including without limitation  #
# the rights to use, copy, modify, merge, publish, distribute, distribute    #
# with modifications, sublicense, and/or sell copies of the Software, and to #
# permit persons to whom the Software is furnished to do so, subject to the  #
# following conditions:                                                      #
#                                                                            #
# The above copyright notice and this permission notice shall be included in #
# all copies or substantial portions of the Software.                        #
#                                                                            #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
# DEALINGS IN THE SOFTWARE.                                                  #
#                                                                            #
# Except as contained in this notice, the name(s) of the above copyright     #
# holders shall not be used in advertising or otherwise to promote the sale, #
# use or other dealings in this Software without prior written               #
# authorization.                                                             #
##############################################################################
# $Id: MKcaptab.awk,v 1.4 2010/01/12 23:22:06 nicm Exp $
function add_string(text) {
    if (text != "IGNORE") {
	offsets[num_strings] = offset;
	offset = offset + length(text) + 1;
	printf "%s\\0", text;
    } else {
	offsets[num_strings] = -1;
    }
    num_strings = num_strings + 1;
    if ((num_strings % 3) == 0) {
	printf "\\\n";
    }
    return offsets[num_strings - 1];
}
BEGIN {
	first = 1;
	num_aliases = 0;
	num_strings = 0;
	offset = 0;
}

/^[^#]/ {
	    if (first) {
		printf "/* generated by MKcaptab.awk %s(%d) */\n", tablename, bigstrings;
		print ""
		if (bigstrings) {
		    printf "static struct alias *_nc_%s_table = 0;\n", tablename;
		    print "";
		    printf "static const char %s_text[] = \"\\\n", tablename;
		} else {
		    printf "static const struct alias _nc_%s_table[] =\n", tablename;
		    printf "{\n";
		}
		first = 0;
	    }
	    if ($1 == tablename) {
		if ($3 == "IGNORE") {
		    to = "(char *)NULL";
		} else {
		    to = "\"" $3 "\"";
		}
		if (bigstrings) {
		    c1 = add_string($2);
		    c2 = add_string($3);
		    c3 = add_string($4);
		    aliases[num_aliases] = sprintf("\t{%5d, %5d, %5d},\t /* %s */", c1, c2, c3, $5);
		    num_aliases = num_aliases + 1;
		} else {
		    printf "\t{\"%s\", %s, \"%s\"},\t /* %s */\n", $2, to, $4, $5;
		}
	    }
	}
END	{
	    if (bigstrings) {
		printf "\";\n\n";
		printf "static const alias_table_data %s_data[] = {\n", tablename;
		for (n = 0; n < num_aliases; ++n) {
		    printf "%s\n", aliases[n];
		}
		printf "};\n\n";
	    } else {
		printf "\t{(char *)NULL, (char *)NULL, (char *)NULL}\n";
		printf "};\n\n";
	    }
	}
# vile:sw=4:
