/*	$OpenBSD: impactreg.h,v 1.1 2010/03/07 21:26:24 miod Exp $	*/
/*
 * Copyright (c) 2010 Miodrag Vallat.
 * Copyright (c) 2009, 2010 Joel Sing <jsing@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * ImpactSR registers
 */

#define	IMPACTSR_REG_OFFSET		0x00000000
#define	IMPACTSR_REG_SIZE		0x00200000

#define	IMPACTSR_STATUS			0x020000
#define	IMPACTSR_FIFOSTATUS		0x020008
#define	IMPACTSR_FIFO_MASK			0x000000ff
#define	IMPACTSR_GIOSTATUS		0x020100
#define	IMPACTSR_DMABUSY		0x020200
#define	IMPACTSR_CFIFO			0x020400

#define	IMPACTSR_CFIFO_HW		0x040000
#define	IMPACTSR_CFIFO_LW		0x040008
#define	IMPACTSR_CFIFO_DELAY		0x040010
#define	IMPACTSR_DFIFO_HW		0x040020
#define	IMPACTSR_DFIFO_LW		0x040028
#define	IMPACTSR_DFIFO_DELAY		0x040030

#define	IMPACTSR_XMAP_PP1SELECT		0x071c08
#define	IMPACTSR_XMAP_INDEX		0x071c88
#define	IMPACTSR_XMAP_CONFIG		0x071d00
#define	IMPACTSR_XMAP_CONFIGB		0x071d08
#define	IMPACTSR_XMAP_BUF_SELECT	0x071d80
#define	IMPACTSR_XMAP_MAIN_MODE		0x071e00
#define	IMPACTSR_XMAP_OVERLAY_MODE	0x071e80
#define	IMPACTSR_XMAP_DIB		0x071f00
#define	IMPACTSR_XMAP_DIB_DW		0x071f40
#define	IMPACTSR_XMAP_RE_RAC		0x071f80

#define	IMPACTSR_VC3_INDEX		0x072008
#define	IMPACTSR_VC3_INDEXDATA		0x072038
#define	IMPACTSR_VC3_DATA		0x0720b0
#define	IMPACTSR_VC3_RAM		0x072190

/*
 * Command FIFO instruction encoding
 */

#define	IMPACTSR_CFIFO_WRITE		0x0018000400000000UL
#define	IMPACTSR_CFIFO_EXEC		0x0004000000000000UL
#define	IMPACTSR_CFIFO_REG_SHIFT	40

/*
 * Command FIFO registers
 */

#define	IMPACTSR_CMD_GLINE_XSTARTF	0x0c
#define	IMPACTSR_CMD_IR_ALIAS		0x45
#define	IMPACTSR_CMD_BLOCKXYSTARTI	0x46	/* XY coords */
#define	IMPACTSR_CMD_BLOCKXYENDI	0x47	/* XY coords */
#define	IMPACTSR_CMD_PACKEDCOLOR	0x5b
#define	IMPACTSR_CMD_ALPHA		0x5f
#define	IMPACTSR_CMD_CHAR_H		0x70
#define	IMPACTSR_CMD_CHAR_L		0x71
#define	IMPACTSR_CMD_XFRCONTROL		0x102
#define	IMPACTSR_CMD_FILLMODE		0x110
#define	IMPACTSR_CMD_CONFIG		0x112
#define	IMPACTSR_CMD_XYWIN		0x115	/* YX coords */
#define	IMPACTSR_CMD_BKGRD_RG		0x140
#define	IMPACTSR_CMD_BKGRD_BA		0x141
#define	IMPACTSR_CMD_XFRSIZE		0x153	/* YX coords */
#define	IMPACTSR_CMD_XFRMASKLO		0x156
#define	IMPACTSR_CMD_XFRMASKHI		0x157
#define	IMPACTSR_CMD_XFRCOUNTERS	0x158	/* YX coords */
#define	IMPACTSR_CMD_XFRMODE		0x159
#define	IMPACTSR_CMD_RE_TOGGLECNTX	0x15f
#define	IMPACTSR_CMD_PP1FILLMODE	0x161
#define	IMPACTSR_CMD_COLORMASKMSBS	0x162
#define	IMPACTSR_CMD_COLORMASKLSBSA	0x163
#define	IMPACTSR_CMD_COLORMASKLSBSB	0x164
#define	IMPACTSR_CMD_DRBPOINTERS	0x16d

#define	IMPACTSR_XYCOORDS(x,y)		(((x) << 16) | (y))
#define	IMPACTSR_YXCOORDS(x,y)		(((y) << 16) | (x))

#define	IMPACTSR_PP1FILLMODE(mode,op)	((mode) | ((op) << 26))

/*
 * Logic Operations
 */

#define OPENGL_LOGIC_OP_CLEAR		0
#define OPENGL_LOGIC_OP_AND		1
#define OPENGL_LOGIC_OP_AND_REVERSE	2
#define OPENGL_LOGIC_OP_COPY		3
#define OPENGL_LOGIC_OP_AND_INVERTED	4
#define OPENGL_LOGIC_OP_NOOP		5
#define OPENGL_LOGIC_OP_XOR		6
#define OPENGL_LOGIC_OP_OR		7
#define OPENGL_LOGIC_OP_NOR		8
#define OPENGL_LOGIC_OP_EQUIV		9
#define OPENGL_LOGIC_OP_INVERT		10
#define OPENGL_LOGIC_OP_OR_REVERSE	11
#define OPENGL_LOGIC_OP_COPY_INVERTED	12
#define OPENGL_LOGIC_OP_OR_INVERTED	13
#define OPENGL_LOGIC_OP_NAND		14
#define OPENGL_LOGIC_OP_SET		15
