/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.FloatingDate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

abstract class DataSetReaderWriter {
    static final String VM_DELIM = "\\";
    static final String VM_DELIM_REGEX = "\\\\";
    private static ThreadLocal formatsTL = new ThreadLocal(){

        protected Object initialValue() {
            return new Formats();
        }
    };
    final Formats formats = (Formats)formatsTL.get();
    static final String DEFAULT_CHARSET = "ISO-8859-1";
    static final HashMap CHARSETS_DICOM_JAVA = new HashMap();
    final boolean isFind;
    String enc = "ISO-8859-1";

    DataSetReaderWriter(boolean bl) {
        this.isFind = bl;
    }

    static {
        CHARSETS_DICOM_JAVA.put("ISO_IR 100", DEFAULT_CHARSET);
        CHARSETS_DICOM_JAVA.put("ISO_IR 101", "ISO-8859-2");
        CHARSETS_DICOM_JAVA.put("ISO_IR 109", "ISO-8859-3");
        CHARSETS_DICOM_JAVA.put("ISO_IR 110", "ISO-8859-4");
        CHARSETS_DICOM_JAVA.put("ISO_IR 144", "ISO-8859-5");
        CHARSETS_DICOM_JAVA.put("ISO_IR 127", "ISO-8859-6");
        CHARSETS_DICOM_JAVA.put("ISO_IR 126", "ISO-8859-7");
        CHARSETS_DICOM_JAVA.put("ISO_IR 138", "ISO-8859-8");
        CHARSETS_DICOM_JAVA.put("ISO_IR 148", "ISO-8859-9");
        CHARSETS_DICOM_JAVA.put("ISO_IR 13", "JIS_X0201");
        CHARSETS_DICOM_JAVA.put("ISO_IR 166", "ISO-8859-11");
        CHARSETS_DICOM_JAVA.put("GB18030", "GB18030");
        CHARSETS_DICOM_JAVA.put("ISO_IR 192", "UTF-8");
    }

    static class Formats {
        SimpleDateFormat dicom3DA = new SimpleDateFormat("yyyyMMdd", Locale.US);
        SimpleDateFormat compatDA = new SimpleDateFormat("yyyy.MM.dd", Locale.US);
        SimpleDateFormat DTWrite = new SimpleDateFormat("yyyyMMddhhmmss.SSS000Z", Locale.US);
        SimpleDateFormat DTWriteFloating = new SimpleDateFormat("yyyyMMddhhmmss.SSS000", Locale.US);
        SimpleDateFormat DTRead = new SimpleDateFormat("yyyyMMddhhmmss.SSSZ", Locale.US);
        SimpleDateFormat DTReadFloating = new SimpleDateFormat("yyyyMMddhhmmss.SSS", Locale.US);
        SimpleDateFormat dicom3TM = new SimpleDateFormat("HHmmss.SSS", Locale.US);
        SimpleDateFormat compatTM = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);

        Formats() {
        }

        String formatDT(Date date) {
            return (date instanceof FloatingDate ? this.DTWriteFloating : this.DTWrite).format(date).trim();
        }
    }
}

