/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4cheri.dict.TagDictionaryLoader;
import org.dcm4cheri.util.IntHashtable2;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TagDictionaryImpl
implements TagDictionary,
Serializable {
    static final long serialVersionUID = 5940638712350400261L;
    private transient IntHashtable2[] tables = new IntHashtable2[]{new IntHashtable2()};

    public TagDictionary.Entry lookup(int tag) {
        for (int i = 0; i < this.tables.length; ++i) {
            Object ret = this.tables[i].get(tag);
            if (ret == null) continue;
            return (TagDictionary.Entry)ret;
        }
        return null;
    }

    public String toString(int tag) {
        TagDictionary.Entry e = this.lookup(tag);
        return e != null ? Tags.toString(tag) + " " + e.name : Tags.toString(tag);
    }

    public final void add(TagDictionary.Entry entry) {
        this.getTableForMask(entry.mask).put(entry.tag, entry);
    }

    public int size() {
        int count = 0;
        for (int i = 0; i < this.tables.length; ++i) {
            count += this.tables[i].size();
        }
        return count;
    }

    private IntHashtable2 getTableForMask(int mask) {
        for (int i = 0; i < this.tables.length; ++i) {
            if (mask != this.tables[i].mask()) continue;
            return this.tables[i];
        }
        IntHashtable2[] tmp = this.tables;
        this.tables = new IntHashtable2[tmp.length + 1];
        System.arraycopy(tmp, 0, this.tables, 0, tmp.length);
        IntHashtable2 newTable = new IntHashtable2();
        newTable.mask(mask);
        this.tables[tmp.length] = newTable;
        tmp = null;
        return newTable;
    }

    public void load(InputSource xmlSource) throws IOException, SAXException {
        new TagDictionaryLoader(this).parse(xmlSource);
    }

    public void load(File xmlFile) throws IOException, SAXException {
        new TagDictionaryLoader(this).parse(xmlFile);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.tables.length);
        for (int i = 0; i < this.tables.length; ++i) {
            this.writeTable(out, this.tables[i]);
        }
    }

    private void writeTable(ObjectOutputStream out, IntHashtable2 table) throws IOException {
        out.writeInt(table.mask());
        out.writeInt(table.size());
        Iterator it = table.iterator();
        while (it.hasNext()) {
            TagDictionary.Entry entry = (TagDictionary.Entry)it.next();
            out.writeInt(entry.tag);
            out.writeUTF(entry.vr);
            out.writeUTF(entry.vm);
            out.writeUTF(entry.name);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.tables = new IntHashtable2[in.readInt()];
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = this.readTable(in);
        }
    }

    private IntHashtable2 readTable(ObjectInputStream in) throws IOException {
        int mask = in.readInt();
        int n = in.readInt();
        IntHashtable2 table = new IntHashtable2(n);
        table.mask(mask);
        for (int i = 0; i < n; ++i) {
            TagDictionary.Entry entry = new TagDictionary.Entry(in.readInt(), mask, in.readUTF(), in.readUTF(), in.readUTF());
            table.put(entry.tag, entry);
        }
        return table;
    }
}

