/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.text.Position;
import open.dolphin.client.AbstractComponentHolder;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IComponentHolder;
import open.dolphin.client.KartePane;
import open.dolphin.client.schemaeditor.SchemaEditorImpl;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.log.LogWriter;

public final class SchemaHolder
extends AbstractComponentHolder
implements IComponentHolder {
    private static final long serialVersionUID = 1777560751402251092L;
    private static final Color SELECTED_BORDER = new Color(255, 0, 153);
    private SchemaModel schema;
    private int fixedSize;
    private int fixedWidth;
    private int fixedHeight;
    private boolean selected;
    private Position start;
    private Position end;
    private KartePane kartePane;
    private Color selectedBorder;

    public SchemaHolder(KartePane kartePane, SchemaModel schema) {
        this.fixedWidth = this.fixedSize = 192;
        this.fixedHeight = this.fixedSize;
        this.selectedBorder = SELECTED_BORDER;
        this.kartePane = kartePane;
        this.setSize(this.fixedWidth, this.fixedHeight);
        this.setMaximumSize(new Dimension(this.fixedWidth, this.fixedHeight));
        this.setMinimumSize(new Dimension(this.fixedWidth, this.fixedHeight));
        this.setPreferredSize(new Dimension(this.fixedWidth, this.fixedHeight));
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.schema = schema;
        this.setImageIcon(schema.getIcon());
    }

    public void setImageIcon(ImageIcon icon) {
        this.setIcon(this.adjustImageSize(icon, new Dimension(this.fixedWidth, this.fixedHeight)));
    }

    @Override
    public int getContentType() {
        return 1;
    }

    @Override
    public KartePane getKartePane() {
        return this.kartePane;
    }

    public SchemaModel getSchema() {
        return this.schema;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void enter(ActionMap map) {
        map.get("copy").setEnabled(true);
        if (this.kartePane.getTextPane().isEditable()) {
            map.get("cut").setEnabled(true);
        } else {
            map.get("cut").setEnabled(false);
        }
        map.get("paste").setEnabled(false);
        this.setSelected(true);
    }

    @Override
    public void exit(ActionMap map) {
        this.setSelected(false);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            popup.setFocusable(false);
            ChartMediator mediator = this.kartePane.getMediator();
            popup.add(mediator.getAction("cut"));
            popup.add(mediator.getAction("copy"));
            popup.add(mediator.getAction("paste"));
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void setSelected(boolean selected) {
        boolean old = this.selected;
        this.selected = selected;
        if (old != this.selected) {
            if (this.selected) {
                this.setBorder(BorderFactory.createLineBorder(this.selectedBorder));
            } else {
                this.setBorder(BorderFactory.createLineBorder(this.kartePane.getTextPane().getBackground()));
            }
        }
    }

    @Override
    public void edit() {
        try {
            final SchemaEditorImpl editor = new SchemaEditorImpl();
            editor.setSchema(this.schema);
            editor.setEditable(this.kartePane.getTextPane().isEditable());
            editor.addPropertyChangeListener((PropertyChangeListener)this);
            Runnable awt = new Runnable(){

                @Override
                public void run() {
                    editor.start();
                    SchemaHolder.this.kartePane.setDirty(true);
                }
            };
            EventQueue.invokeLater(awt);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), "", (Throwable)e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        SchemaModel newSchema = (SchemaModel)e.getNewValue();
        if (newSchema == null) {
            return;
        }
        this.schema = newSchema;
        this.setIcon(this.adjustImageSize(this.schema.getIcon(), new Dimension(this.fixedWidth, this.fixedHeight)));
    }

    @Override
    public void setEntry(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int getStartPos() {
        return this.start.getOffset();
    }

    @Override
    public int getEndPos() {
        return this.end.getOffset();
    }

    protected ImageIcon adjustImageSize(ImageIcon icon, Dimension dim) {
        if (icon.getIconHeight() > dim.height || icon.getIconWidth() > dim.width) {
            int w;
            int h;
            float wRatio;
            Image img = icon.getImage();
            float hRatio = (float)icon.getIconHeight() / (float)dim.height;
            if (hRatio > (wRatio = (float)icon.getIconWidth() / (float)dim.width)) {
                h = dim.height;
                w = (int)((float)icon.getIconWidth() / hRatio);
            } else {
                w = dim.width;
                h = (int)((float)icon.getIconHeight() / wRatio);
            }
            img = img.getScaledInstance(w, h, 4);
            return new ImageIcon(img);
        }
        return icon;
    }
}

