/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.queries.DolphinQuery;

public class AllergyModel
extends InfoModel
implements Comparable {
    private static final long serialVersionUID = -6327488237646390391L;
    private long observationId;
    private String factor;
    private String severity;
    private String severityTableId;
    private String identifiedDate;
    private String memo;

    @Override
    public boolean search(DolphinQuery query) {
        if (this.factor != null) {
            return this.factor.indexOf(query.what("keyword")) != -1;
        }
        return false;
    }

    public String getFactor() {
        return this.factor;
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

    public String getIdentifiedDate() {
        return this.identifiedDate;
    }

    public String getIdentifiedFormatDate() {
        return ModelUtils.Convert("yyyy-MM-dd", "yyyy-MM-dd'('EEE')'", this.identifiedDate);
    }

    public void setIdentifiedDate(String identifiedDate) {
        this.identifiedDate = identifiedDate;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverityTableId() {
        return this.severityTableId;
    }

    public void setSeverityTableId(String severityTableId) {
        this.severityTableId = severityTableId;
    }

    public int compareTo(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            String val1 = this.getIdentifiedDate();
            String val2 = ((AllergyModel)other).getIdentifiedDate();
            return val1.compareTo(val2);
        }
        return 1;
    }

    public long getObservationId() {
        return this.observationId;
    }

    public void setObservationId(long observationId) {
        this.observationId = observationId;
    }

    public void serialize(Writer result) throws IOException {
        result.append("<AllergyModel observationId='" + Long.toString(this.observationId) + "' factor='" + this.factor + "' severity='" + this.severity + "' severityTableId='" + this.severityTableId + "' identifiedDate='" + this.identifiedDate + "' memo='" + this.memo + "' />" + System.getProperty("line.separator"));
    }
}

