/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.ArrayList;
import java.util.List;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.log.LogWriter;
import open.dolphin.service.DolphinService;
import open.dolphin.service.ILaboService;
import org.hibernate.HibernateException;

public class RemoteLaboService
extends DolphinService
implements ILaboService {
    @Override
    public KarteBean getKarteFor(String patientId) throws HibernateException {
        KarteBean karte;
        block4: {
            this.roleAllowed("user");
            karte = null;
            try {
                this.startTransaction();
                String facilityId = this.getCallersFacilityId();
                PatientModel exist = (PatientModel)this.getSession().createQuery("from PatientModel p where p.facilityId = :fid and p.patientId = :pid").setParameter("fid", (Object)facilityId).setParameter("pid", (Object)patientId).uniqueResult();
                if (exist == null) {
                    throw new HibernateException("No Such Patient");
                }
                karte = (KarteBean)this.getSession().createQuery("from KarteBean k where k.patient.id = :pk").setParameter("pk", (Object)exist.getId()).uniqueResult();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (this.getSession().getTransaction().isActive()) {
                    this.getSession().getTransaction().rollback();
                    LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
                }
                if (!e.getMessage().equals("No Such Patient")) break block4;
                throw e;
            }
        }
        return karte;
    }

    @Override
    public PatientModel putLaboModule(LaboModuleValue laboModuleValue) {
        PatientModel exist;
        block4: {
            this.roleAllowed("user");
            exist = null;
            try {
                this.startTransaction();
                String facilityId = this.getCallersFacilityId();
                exist = (PatientModel)this.getSession().createQuery("from PatientModel p where p.facilityId = :fid and p.patientId = :pid").setParameter("fid", (Object)facilityId).setParameter("pid", (Object)laboModuleValue.getPatientId()).uniqueResult();
                if (exist == null) {
                    throw new HibernateException("No Such Patient");
                }
                KarteBean karte = (KarteBean)this.getSession().createQuery("from KarteBean k where k.patient.id = :pk").setParameter("pk", (Object)exist.getId()).uniqueResult();
                laboModuleValue.setKarte(karte);
                this.getSession().persist((Object)laboModuleValue);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (this.getSession().getTransaction().isActive()) {
                    this.getSession().getTransaction().rollback();
                    LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
                }
                if (!e.getMessage().equals("No Such Patient")) break block4;
                throw e;
            }
        }
        return exist;
    }

    @Override
    public List<LaboModuleValue> getModulesFor(long karteId) {
        List<LaboModuleValue> modules;
        block2: {
            this.roleAllowed("user");
            modules = new ArrayList<LaboModuleValue>();
            try {
                this.startTransaction();
                modules = this.getSession().createQuery("from LaboModuleValue where karte_id = :karteId").setParameter("karteId", (Object)karteId).list();
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return modules;
    }
}

