/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.LangUtils;

public class HttpHost
implements Cloneable {
    private String hostname = null;
    private int port = -1;
    private Protocol protocol = null;

    public HttpHost(String string, int n, Protocol protocol) {
        if (string == null) {
            throw new IllegalArgumentException("Host name may not be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol may not be null");
        }
        this.hostname = string;
        this.protocol = protocol;
        this.port = n >= 0 ? n : this.protocol.getDefaultPort();
    }

    public HttpHost(String string, int n) {
        this(string, n, Protocol.getProtocol("http"));
    }

    public HttpHost(String string) {
        this(string, -1, Protocol.getProtocol("http"));
    }

    public HttpHost(URI uRI) throws URIException {
        this(uRI.getHost(), uRI.getPort(), Protocol.getProtocol(uRI.getScheme()));
    }

    public HttpHost(HttpHost httpHost) {
        this.hostname = httpHost.hostname;
        this.port = httpHost.port;
        this.protocol = httpHost.protocol;
    }

    public Object clone() {
        return new HttpHost(this);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String toURI() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.protocol != null) {
            stringBuffer.append(this.protocol.getScheme());
            stringBuffer.append("://");
        }
        stringBuffer.append(this.hostname);
        if (this.port != this.protocol.getDefaultPort()) {
            stringBuffer.append(':');
            stringBuffer.append(this.port);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.toURI());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof HttpHost) {
            if (object == this) {
                return true;
            }
            HttpHost httpHost = (HttpHost)object;
            if (!this.hostname.equalsIgnoreCase(httpHost.hostname)) {
                return false;
            }
            if (this.port != httpHost.port) {
                return false;
            }
            return this.protocol.equals(httpHost.protocol);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.hostname);
        n = LangUtils.hashCode(n, this.port);
        n = LangUtils.hashCode(n, this.protocol);
        return n;
    }
}

