/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import open.dolphin.client.AgreementModel;
import open.dolphin.configure.GlobalSettings;

public class AgreementPanel
extends JPanel {
    private static final long serialVersionUID = -2621821413657989752L;
    public static final String AGREE_PROP = "agreeProp";
    private AgreementModel model;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private static final String AGREE_TEXT = "\u540c\u610f\u3059\u308b";
    private static final String DISAGREE_TEXT = "\u540c\u610f\u3057\u306a\u3044";
    private JTextArea agreeArea;
    private JRadioButton agreeBtn;
    private JRadioButton disagreeBtn;

    public AgreementPanel(AgreementModel model) {
        this.initComponents();
        this.initialize();
        this.connect();
        this.setModel(model);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public AgreementModel getModel() {
        return this.model;
    }

    public void setModel(AgreementModel model) {
        this.model = model;
        if (model != null) {
            this.agreeArea.setText(model.getAgreeText());
            this.agreeBtn.setSelected(model.isAgree());
            this.disagreeBtn.setSelected(!model.isAgree());
        }
    }

    public boolean isAgree() {
        return this.getModel().isAgree();
    }

    public void setAgree(boolean newAgree) {
        boolean old = this.getModel().isAgree();
        this.getModel().setAgree(newAgree);
        this.boundSupport.firePropertyChange(AGREE_PROP, old, this.getModel().isAgree());
    }

    public void addAgreePropertyListener(PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(AGREE_PROP, l);
    }

    public void removeAgreePropertyListener(PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(AGREE_PROP, l);
    }

    private void initialize() {
        this.agreeArea = new JTextArea();
        this.agreeArea.setEditable(false);
        this.agreeArea.setLineWrap(true);
        this.agreeArea.setMargin(new Insets(10, 10, 10, 10));
        this.agreeBtn = new JRadioButton(AGREE_TEXT);
        this.disagreeBtn = new JRadioButton(DISAGREE_TEXT);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.agreeBtn);
        bg.add(this.disagreeBtn);
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        btnPanel.add(this.agreeBtn);
        btnPanel.add(this.disagreeBtn);
        JScrollPane scroller = new JScrollPane(this.agreeArea, 20, 31);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        this.add((Component)btnPanel, "South");
    }

    private void connect() {
        ActionListener agreeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgreementPanel.this.setAgree(AgreementPanel.this.agreeBtn.isSelected());
            }
        };
        this.agreeBtn.addActionListener(agreeListener);
        this.disagreeBtn.addActionListener(agreeListener);
    }
}

