/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.DoBodyObject;
import open.dolphin.client.DoHeaderObject;
import open.dolphin.client.DoStampTreeNodeTransferable;
import open.dolphin.client.KartePane;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.OrderList;
import open.dolphin.client.OrderListTransferable;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.log.LogWriter;

public class KartePaneTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -7891004155072724783L;
    private DataFlavor stringFlavor = DataFlavor.stringFlavor;
    private KartePane pPane;
    private JTextPane source;
    private boolean shouldRemove;
    Position p0 = null;
    Position p1 = null;

    public KartePaneTransferHandler(KartePane pPane) {
        this.pPane = pPane;
    }

    @Override
    public boolean importData(JComponent c, Transferable tr) {
        JTextPane tc = (JTextPane)c;
        if (!this.canImport(c, tr.getTransferDataFlavors())) {
            return false;
        }
        if (tc.equals(this.source) && tc.getCaretPosition() >= this.p0.getOffset() && tc.getCaretPosition() <= this.p1.getOffset()) {
            this.shouldRemove = false;
            return true;
        }
        try {
            if (tr.isDataFlavorSupported(DoStampTreeNodeTransferable.doStampTreeNodeFlavor)) {
                return this.orcaDoStampInfoDrop(tr);
            }
            if (tr.isDataFlavorSupported(LocalStampTreeNodeTransferable.localStampTreeNodeFlavor)) {
                this.shouldRemove = false;
                return this.stampInfoDrop(tr);
            }
            if (tr.isDataFlavorSupported(OrderListTransferable.orderListFlavor)) {
                return this.doStampDrop(tr);
            }
            if (tr.isDataFlavorSupported(this.stringFlavor)) {
                String str = (String)tr.getTransferData(this.stringFlavor);
                tc.replaceSelection(str);
                this.shouldRemove = tc == this.source;
                return true;
            }
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.source = (JTextPane)c;
        int start = this.source.getSelectionStart();
        int end = this.source.getSelectionEnd();
        Document doc = this.source.getDocument();
        if (start == end) {
            return null;
        }
        try {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        String data = this.source.getSelectedText();
        return new StringSelection(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        JTextComponent tc = (JTextComponent)c;
        if (tc.isEditable() && this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        this.shouldRemove = false;
        this.source = null;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        JTextPane tc = (JTextPane)c;
        return tc.isEditable() && this.hasFlavor(flavors);
    }

    protected boolean hasFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (this.stringFlavor.equals(flavor)) {
                return true;
            }
            if (LocalStampTreeNodeTransferable.localStampTreeNodeFlavor.equals(flavor)) {
                return true;
            }
            if (OrderListTransferable.orderListFlavor.equals(flavor)) {
                return true;
            }
            if (!DoStampTreeNodeTransferable.doStampTreeNodeFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    private boolean orcaDoStampInfoDrop(Transferable transferable) {
        try {
            try {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)transferable.getTransferData(DoStampTreeNodeTransferable.doStampTreeNodeFlavor);
                DoHeaderObject header = (DoHeaderObject)root.getUserObject();
                DefaultMutableTreeNode currentNode = null;
                Enumeration<TreeNode> e = root.children();
                while (e.hasMoreElements()) {
                    currentNode = (DefaultMutableTreeNode)e.nextElement();
                    DoBodyObject body = (DoBodyObject)currentNode.getUserObject();
                }
            }
            catch (IOException ex) {
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return true;
    }

    private boolean stampInfoDrop(Transferable tr) {
        try {
            StampTreeNode droppedNode = (StampTreeNode)tr.getTransferData(LocalStampTreeNodeTransferable.localStampTreeNodeFlavor);
            if (droppedNode.isLeaf()) {
                ModuleInfoBean stampInfo = droppedNode.getStampInfo();
                String role = stampInfo.getStampRole();
                if (role.equals("p")) {
                    this.pPane.stampInfoDropped(stampInfo);
                } else if (role.equals("text")) {
                    this.pPane.stampInfoDropped(stampInfo);
                } else if (role.equals("orcaSet")) {
                    this.pPane.stampInfoDropped(stampInfo);
                }
                return true;
            }
            Enumeration<TreeNode> e = droppedNode.preorderEnumeration();
            ArrayList<ModuleInfoBean> addList = new ArrayList<ModuleInfoBean>();
            String role = null;
            while (e.hasMoreElements()) {
                StampTreeNode node = (StampTreeNode)e.nextElement();
                if (!node.isLeaf()) continue;
                ModuleInfoBean stampInfo = node.getStampInfo();
                role = stampInfo.getStampRole();
                if (!stampInfo.isSerialized() || !role.equals("p") && !role.equals("text")) continue;
                addList.add(stampInfo);
            }
            if (role == null) {
                return true;
            }
            if (role.equals("text")) {
                this.pPane.textStampInfoDropped(addList);
            } else if (role.equals("p")) {
                this.pPane.stampInfoDropped(addList);
            }
            return true;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return false;
        }
    }

    private boolean doStampDrop(Transferable tr) {
        try {
            OrderList list = (OrderList)tr.getTransferData(OrderListTransferable.orderListFlavor);
            ModuleModel[] stamps = list.getOrderList();
            for (int i = 0; i < stamps.length; ++i) {
                this.pPane.stamp(stamps[i]);
            }
            if (this.pPane.getDraggedCount() > 0 && this.pPane.getDrragedStamp() != null) {
                this.pPane.setDroppedCount(stamps.length);
            }
            return true;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return false;
        }
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        JTextPane pane;
        super.exportToClipboard(comp, clip, action);
        if (action == 2 && (pane = (JTextPane)comp).isEditable()) {
            pane.replaceSelection("");
        }
    }
}

