/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.LetterReplyView;
import open.dolphin.client.PDFReplyMaker;
import open.dolphin.client.PrintablePanel;
import open.dolphin.delegater.remote.RemoteSetaDelegater;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.infomodel.TouTouReply;
import open.dolphin.infomodel.UserModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;

public class LetterReplyImpl
extends PrintablePanel
implements IChartDocument,
IChartCommandAccepter {
    private static final String TITLE = "\u7d39\u4ecb\u60a3\u8005\u7d4c\u904e\u5831\u544a\u66f8";
    private TouTouReply model;
    private LetterReplyView view;
    private StateMgr stateMgr;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = "\u7d39\u4ecb\u60a3\u8005\u7d4c\u904e\u5831\u544a\u66f8";
    private boolean dirty;

    public LetterReplyImpl(IChart parent) {
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.LetterReplyImpl;
    }

    private void setModelValue(JTextField tf, String value) {
        if (value != null) {
            tf.setText(value);
        }
    }

    private String getFieldValue(JTextField tf) {
        String ret = tf.getText().trim();
        if (!ret.equals("")) {
            return ret;
        }
        return null;
    }

    private String getAreaValue(JTextArea ta) {
        String ret = ta.getText().trim();
        if (!ret.equals("")) {
            return ret;
        }
        return null;
    }

    private String dateToLocaleDateString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5");
        return sdf.format(date);
    }

    private String mmlDateStringToLocaleDateString(String mmlDate) {
        Date d = ModelUtils.getDateAsObject(mmlDate);
        return this.dateToLocaleDateString(d);
    }

    private void displayModel(TouTouReply model) {
        String dateStr = this.dateToLocaleDateString(model.getConfirmed());
        this.view.getConfirmed().setText(dateStr);
        this.view.getVisited().setText(model.getVisited());
        String birthdayStr = this.mmlDateStringToLocaleDateString(model.getPatientBirthday());
        this.setModelValue(this.view.getPatientName(), model.getPatientName());
        this.setModelValue(this.view.getPatientBirthday(), birthdayStr);
        this.setModelValue(this.view.getPatientName(), model.getPatientName());
    }

    private void restore(TouTouReply model) {
        Date d = new Date();
        model.setConfirmed(d);
        model.setRecorded(d);
        model.setStarted(d);
        model.setStatus("F");
        model.setKarte(this.getParentContext().getKarte());
        model.setCreator(GlobalVariables.getUserModel());
        model.setClientHospital(this.getFieldValue(this.view.getClientHospital()));
        model.setClientDept(this.getFieldValue(this.view.getClientDept()));
        model.setClientDoctor(this.getFieldValue(this.view.getClientDoctor()));
        String visited = this.getFieldValue(this.view.getVisited());
        model.setVisited(visited);
        model.setInformedContent(this.getAreaValue(this.view.getInformedContent()));
    }

    @Override
    public void start() {
        this.model = new TouTouReply();
        Date d = new Date();
        this.model.setConfirmed(d);
        this.model.setVisited(ModelUtils.getDateAsFormatString(d, "yyyy-MM-dd"));
        PatientModel patient = this.getParentContext().getPatient();
        this.model.setPatientName(patient.getFullName());
        this.model.setPatientGender(patient.getGenderDesc());
        this.model.setPatientBirthday(patient.getBirthday());
        this.model.setPatientAge(ModelUtils.getAge(patient.getBirthday()));
        UserModel user = GlobalVariables.getUserModel();
        this.model.setConsultantHospital(user.getFacility().getFacilityName());
        this.model.setConsultantDoctor(user.getCommonName());
        this.view = new LetterReplyView();
        JScrollPane scroller = new JScrollPane(this.view);
        scroller.getVerticalScrollBar().setUnitIncrement(GlobalSettings.karteScrollUnitIncrement());
        this.setLayout(new BorderLayout());
        this.add(scroller);
        this.displayModel(this.model);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LetterReplyImpl.this.stateMgr.processDirtyEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LetterReplyImpl.this.stateMgr.processDirtyEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LetterReplyImpl.this.stateMgr.processDirtyEvent();
            }
        };
        this.view.getClientHospital().getDocument().addDocumentListener(dl);
        this.view.getClientDept().getDocument().addDocumentListener(dl);
        this.view.getClientDoctor().getDocument().addDocumentListener(dl);
        this.view.getVisited().getDocument().addDocumentListener(dl);
        this.view.getInformedContent().getDocument().addDocumentListener(dl);
        this.view.getClientHospital().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getClientDept().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getClientDoctor().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getVisited().addFocusListener(AutoRomanListener.getInstance());
        this.view.getInformedContent().addFocusListener(AutoKanjiListener.getInstance());
        PopupListener popupListener = new PopupListener(this.view.getVisited());
        this.stateMgr = new StateMgr();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    private boolean save() {
        this.restore(this.model);
        RemoteSetaDelegater ddl = new RemoteSetaDelegater();
        long result = ddl.saveOrUpdateLetter(this.model);
        if (ddl.isNoError()) {
            this.model.setId(result);
        }
        this.stateMgr.processSavedEvent();
        this.getParentContext().getDocumentHistory().getDocumentHistory();
        this.closeEditor();
        return true;
    }

    private void closeEditor() {
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("direction", false);
        this.getParentContext().closeChartDocument(this.title, this);
        this.getParentContext().getChartMediator().unsetAccepter(this);
    }

    @Override
    public void enter() {
        this.getParentContext().getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        if (this.stateMgr != null) {
            this.stateMgr.enter();
        }
    }

    private boolean print() {
        if (this.model == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PDF\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b?");
        int option = JOptionPane.showOptionDialog(this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u5370\u5237"), -1, 1, null, new String[]{"PDF\u4f5c\u6210", "\u30d5\u30a9\u30fc\u30e0\u5370\u5237", "\u53d6\u6d88\u3057"}, "PDF\u4f5c\u6210");
        if (option == 0) {
            this.save();
            this.makePDF();
        } else if (option == 1) {
            PageFormat pageFormat = this.getParentContext().getContext().getPageFormat();
            String name = this.getParentContext().getPatient().getFullName();
            LetterReplyView panel = this.view;
            panel.printPanel(pageFormat, 1, false, name, 0);
        }
        return true;
    }

    public void makePDF() {
        if (this.model == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PDFReplyMaker pdf = new PDFReplyMaker();
                String pdfDir = GlobalVariables.getPreferences().get("pdfStore", System.getProperty("user.dir"));
                pdf.setDocumentDir(pdfDir);
                pdf.setModel(LetterReplyImpl.this.model);
                final boolean result = pdf.create();
                final String fileName = pdf.getFileName();
                final String dir = pdf.getDocumentDir();
                Runnable awt = new Runnable(){

                    @Override
                    public void run() {
                        if (result) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(fileName);
                            sb.append("\u3092");
                            sb.append("\n");
                            sb.append(dir);
                            sb.append("\u306b\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
                            sb.append("\n");
                            sb.append("PDF \u30d3\u30e5\u30ef\u30fc\u3092\u8d77\u52d5\u3057\u5370\u5237\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                            JOptionPane.showMessageDialog(LetterReplyImpl.this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u4f5c\u6210"), 1);
                        } else {
                            JOptionPane.showMessageDialog(LetterReplyImpl.this.getParentContext().getFrame(), "\u7d39\u4ecb\u72b6PDF\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u4f5c\u6210"), 2);
                        }
                    }
                };
                EventQueue.invokeLater(awt);
            }
        };
        Thread t = new Thread(r);
        t.setPriority(5);
        t.start();
    }

    @Override
    public boolean isDirty() {
        if (this.stateMgr != null) {
            return this.stateMgr.isDirtyState();
        }
        return this.dirty;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case modifyKarte: {
                return this.modifyKarte();
            }
            case save: {
                return this.save();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    private boolean modifyKarte() {
        this.stateMgr.processModifyKarteEvent();
        return true;
    }

    private void setEditables(boolean b) {
        this.view.getClientHospital().setEditable(b);
        this.view.getClientDept().setEditable(b);
        this.view.getClientDoctor().setEditable(b);
        this.view.getVisited().setEditable(b);
        this.view.getInformedContent().setEditable(b);
    }

    @Override
    public boolean itLayoutSaved() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.getParentContext().isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    class PopupListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private JPopupMenu popup;
        private JTextField tf;

        public PopupListener(JTextField tf) {
            this.tf = tf;
            tf.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup = new JPopupMenu();
                CalendarCardPanel cc = new CalendarCardPanel(GlobalConstants.getEventColorTable());
                cc.addPropertyChangeListener("pickedDate", this);
                cc.setCalendarRange(new int[]{-12, 0});
                this.popup.insert(cc, 0);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("pickedDate")) {
                SimpleDate sd = (SimpleDate)e.getNewValue();
                String mmldate = SimpleDate.simpleDateToMmldate(sd);
                this.tf.setText(mmldate);
                this.popup.setVisible(false);
                this.popup = null;
            }
        }
    }

    class StateMgr {
        private EmptyState emptyState;
        private DirtyState dirtyState;
        private CleanState cleanState;
        private StartEditingState startEditingState;
        private State curState;

        public StateMgr() {
            this.emptyState = new EmptyState();
            this.dirtyState = new DirtyState();
            this.cleanState = new CleanState();
            this.startEditingState = new StartEditingState();
            this.curState = this.emptyState;
            this.enter();
        }

        public void enter() {
            this.curState.enter();
        }

        public void processDirtyEvent() {
            boolean newDirty;
            boolean bl = newDirty = LetterReplyImpl.this.getFieldValue(LetterReplyImpl.this.view.getClientHospital()) != null && LetterReplyImpl.this.getAreaValue(LetterReplyImpl.this.view.getInformedContent()) != null;
            if (this.isDirtyState() != newDirty) {
                this.curState = newDirty ? this.dirtyState : this.emptyState;
                this.curState.enter();
            }
        }

        public void processSavedEvent() {
            this.curState = this.cleanState;
            this.curState.enter();
        }

        public void processModifyKarteEvent() {
            this.curState = this.startEditingState;
            this.curState.enter();
        }

        public boolean isDirtyState() {
            return this.curState == this.dirtyState;
        }
    }

    class StartEditingState
    extends State {
        StartEditingState() {
        }

        @Override
        public void enter() {
            LetterReplyImpl.this.setEditables(true);
            LetterReplyImpl.this.getParentContext().enabledAction("save", false);
            LetterReplyImpl.this.getParentContext().enabledAction("print", true);
            LetterReplyImpl.this.getParentContext().enabledAction("direction", true);
            LetterReplyImpl.this.getParentContext().enabledAction("modifyKarte", false);
            LetterReplyImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    class CleanState
    extends State {
        CleanState() {
        }

        @Override
        public void enter() {
            LetterReplyImpl.this.setEditables(false);
            LetterReplyImpl.this.getParentContext().enabledAction("save", false);
            LetterReplyImpl.this.getParentContext().enabledAction("print", true);
            LetterReplyImpl.this.getParentContext().enabledAction("direction", true);
            LetterReplyImpl.this.getParentContext().enabledAction("modifyKarte", true);
            LetterReplyImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    class DirtyState
    extends State {
        DirtyState() {
        }

        @Override
        public void enter() {
            LetterReplyImpl.this.getParentContext().enabledAction("save", true);
            LetterReplyImpl.this.getParentContext().enabledAction("print", true);
            LetterReplyImpl.this.getParentContext().enabledAction("direction", true);
            LetterReplyImpl.this.getParentContext().enabledAction("modifyKarte", false);
            LetterReplyImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    class EmptyState
    extends State {
        EmptyState() {
        }

        @Override
        public void enter() {
            LetterReplyImpl.this.getParentContext().enabledAction("save", false);
            LetterReplyImpl.this.getParentContext().enabledAction("print", false);
            LetterReplyImpl.this.getParentContext().enabledAction("direction", false);
            LetterReplyImpl.this.getParentContext().enabledAction("modifyKarte", false);
            LetterReplyImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    abstract class State {
        State() {
        }

        public abstract void enter();
    }
}

