/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.delegater.remote.RemotePVTDelegater;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.log.LogWriter;

public class ModelSender {
    private static ModelSender instance = new ModelSender();
    private LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private Thread sender;
    private ModelConsumer consumer = new ModelConsumer();

    public static ModelSender getInstance() {
        return instance;
    }

    private ModelSender() {
        this.sender = new Thread(this.consumer);
        this.sender.setPriority(5);
        this.sender.start();
    }

    public void offer(Object model) {
        this.queue.offer(model);
    }

    public Object take() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException ex) {
            LogWriter.error(this.getClass(), ex);
            return null;
        }
    }

    public void stop() {
        Thread moribound = this.sender;
        this.sender = null;
        moribound.interrupt();
    }

    private Callable<Long> getDocumentTask(final DocumentModel model) {
        Callable c = new Callable(){

            public Long call() {
                RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
                long result = ddl.putDocument(model);
                return new Long(result);
            }
        };
        return c;
    }

    private Callable<Integer> getPvtTask(final PatientVisitModel model) {
        Callable c = new Callable(){

            public Integer call() {
                RemotePVTDelegater pdl = new RemotePVTDelegater();
                int result = pdl.addPvt(model);
                return new Integer(result);
            }
        };
        return c;
    }

    class ModelConsumer
    implements Runnable {
        ModelConsumer() {
        }

        @Override
        public void run() {
            while (true) {
                Object model;
                if ((model = ModelSender.this.take()) == null) {
                    continue;
                }
                try {
                    FutureTask task = null;
                    if (model instanceof PatientVisitModel) {
                        task = new FutureTask(ModelSender.this.getPvtTask((PatientVisitModel)model));
                        LogWriter.debug(this.getClass(), "created pvt FutureTask");
                    } else if (model instanceof DocumentModel) {
                        task = new FutureTask(ModelSender.this.getDocumentTask((DocumentModel)model));
                    }
                    new Thread(task).start();
                    task.get(120L, TimeUnit.SECONDS);
                    continue;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                catch (ExecutionException ex) {
                    continue;
                }
                catch (TimeoutException ex) {
                    ModelSender.this.offer(model);
                    continue;
                }
                break;
            }
        }
    }
}

