/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.TouTouLetter;

public class PDFLetterMaker {
    private static final String DOC_TITLE = "\u8a3a\u7642\u60c5\u5831\u63d0\u4f9b\u66f8";
    private static final String GREETINGS = "\u4e0b\u8a18\u306e\u60a3\u8005\u3055\u3093\u3092\u7d39\u4ecb\u81f4\u3057\u307e\u3059\u3002\u3054\u9ad8\u8a3a\u306e\u7a0b\u5b9c\u3057\u304f\u304a\u9858\u3044\u7533\u3057\u4e0a\u3052\u307e\u3059\u3002";
    private static final String HEISEI_MIN_W3 = "HeiseiMin-W3";
    private static final String UNIJIS_UCS2_HW_H = "UniJIS-UCS2-HW-H";
    private static final int TOP_MARGIN = 75;
    private static final int LEFT_MARGIN = 75;
    private static final int BOTTOM_MARGIN = 75;
    private static final int RIGHT_MARGIN = 75;
    private static final int TITLE_FONT_SIZE = 14;
    private static final int BODY_FONT_SIZE = 12;
    private String documentDir;
    private String fileName;
    private TouTouLetter model;
    private int marginLeft = 75;
    private int marginRight = 75;
    private int marginTop = 75;
    private int marginBottom = 75;
    private BaseFont baseFont;
    private Font titleFont;
    private Font bodyFont;
    private int titleFontSize = 14;
    private int bodyFontSize = 12;

    public boolean create() {
        boolean result = true;
        try {
            Document document = new Document(PageSize.A4, (float)this.getMarginLeft(), (float)this.getMarginRight(), (float)this.getMarginTop(), (float)this.getMarginBottom());
            if (this.documentDir == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(System.getProperty("user.dir"));
                sb.append(File.separator);
                sb.append("pdf");
                this.setDocumentDir(sb.toString());
            }
            File dir = new File(this.getDocumentDir());
            dir.mkdir();
            String name = this.model.getPatientName();
            name = name.replaceAll(" ", "");
            name = name.replaceAll("\u3000", "");
            StringBuilder sb = new StringBuilder();
            sb.append("\u7d39\u4ecb\u72b6-");
            sb.append(name);
            sb.append("\u69d8-");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sb.append(sdf.format(new Date()));
            sb.append(".pdf");
            this.setFileName(sb.toString());
            sb = new StringBuilder();
            if (this.getDocumentDir() != null) {
                sb.append(this.getDocumentDir());
                sb.append(File.separator);
            }
            sb.append(this.getFileName());
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(sb.toString()));
            document.open();
            this.baseFont = BaseFont.createFont((String)HEISEI_MIN_W3, (String)UNIJIS_UCS2_HW_H, (boolean)false);
            this.titleFont = new Font(this.baseFont, (float)this.getTitleFontSize());
            this.bodyFont = new Font(this.baseFont, (float)this.getBodyFontSize());
            Paragraph para = new Paragraph(DOC_TITLE, this.titleFont);
            para.setAlignment(1);
            document.add((Element)para);
            String dateStr = this.getDateString(this.model.getConfirmed());
            para = new Paragraph(dateStr, this.bodyFont);
            para.setAlignment(2);
            document.add((Element)para);
            document.add((Element)new Paragraph("\u3000"));
            Paragraph para2 = new Paragraph(this.model.getConsultantHospital(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            para2 = new Paragraph(this.model.getConsultantDept(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            sb = new StringBuilder();
            String tech = this.model.getConsultantDoctor();
            if (tech == null) {
                tech = "";
            } else {
                sb.append(tech);
                sb.append(" \u5148\u751f");
            }
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            para2 = new Paragraph(this.model.getClientHospital(), this.bodyFont);
            para2.setAlignment(2);
            document.add((Element)para2);
            sb = new StringBuilder();
            sb.append(this.model.getClientName());
            sb.append(" \u5370");
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(2);
            document.add((Element)para2);
            para2 = new Paragraph(this.model.getClientAddress(), this.bodyFont);
            para2.setAlignment(2);
            document.add((Element)para2);
            sb = new StringBuilder();
            sb.append("\u96fb\u8a71 ");
            sb.append(this.model.getClientTelephone());
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(2);
            document.add((Element)para2);
            document.add((Element)new Paragraph("\u3000"));
            para2 = new Paragraph(GREETINGS, this.bodyFont);
            para2.setAlignment(1);
            document.add((Element)para2);
            Table pTable = new Table(4);
            pTable.setPadding(2.0f);
            int[] width = new int[]{20, 60, 10, 10};
            pTable.setWidths(width);
            pTable.setWidth(100.0f);
            String birthday = this.getDateString(this.model.getPatientBirthday());
            String sexStr = this.getSexString(this.model.getPatientGender());
            pTable.addCell(new Phrase("\u60a3\u8005\u6c0f\u540d", this.bodyFont));
            pTable.addCell(new Phrase(this.model.getPatientName(), this.bodyFont));
            pTable.addCell(new Phrase("\u6027\u5225", this.bodyFont));
            pTable.addCell(new Phrase(sexStr, this.bodyFont));
            pTable.addCell(new Phrase("\u751f\u5e74\u6708\u65e5", this.bodyFont));
            sb = new StringBuilder();
            sb.append(birthday);
            sb.append(" (");
            sb.append(this.model.getPatientAge());
            sb.append(" \u6b73)");
            Cell cell = new Cell((Element)new Phrase(sb.toString(), this.bodyFont));
            cell.setColspan(3);
            pTable.addCell(cell);
            document.add((Element)pTable);
            Table lTable = new Table(2);
            lTable.setPadding(2.0f);
            width = new int[]{20, 80};
            lTable.setWidths(width);
            lTable.setWidth(100.0f);
            lTable.addCell(new Phrase("\u50b7\u75c5\u540d", this.bodyFont));
            lTable.addCell(new Phrase(this.model.getDisease(), this.bodyFont));
            lTable.addCell(new Phrase("\u7d39\u4ecb\u76ee\u7684", this.bodyFont));
            lTable.addCell(new Phrase(this.model.getPurpose(), this.bodyFont));
            lTable.addCell(new Phrase("\u65e2\u5f80\u6b74\n\u5bb6\u65cf\u6b74", this.bodyFont));
            cell = new Cell((Element)new Phrase(this.model.getPastFamily(), this.bodyFont));
            lTable.addCell(cell);
            lTable.addCell(new Phrase("\u75c7\u72b6\u7d4c\u904e\n\u691c\u67fb\u7d50\u679c\n\u6cbb\u7642\u7d4c\u904e", this.bodyFont));
            lTable.addCell(new Phrase(this.model.getClinicalCourse(), this.bodyFont));
            lTable.addCell(new Phrase("\u73fe\u5728\u306e\u51e6\u65b9", this.bodyFont));
            lTable.addCell(new Phrase(this.model.getMedication(), this.bodyFont));
            lTable.addCell(new Phrase("\u5099 \u8003", this.bodyFont));
            lTable.addCell(new Phrase(this.model.getRemarks(), this.bodyFont));
            document.add((Element)lTable);
            document.close();
        }
        catch (IOException ex) {
            result = false;
        }
        catch (DocumentException ex) {
            result = false;
        }
        return result;
    }

    private String getDateString(Date d) {
        return ModelUtils.getDateAsFormatString(d, "yyyy\u5e74M\u6708d\u65e5");
    }

    private String getDateString(String date) {
        Date d = ModelUtils.getDateAsObject(date);
        return ModelUtils.getDateAsFormatString(d, "yyyy\u5e74M\u6708d\u65e5");
    }

    private String getSexString(String sex) {
        return sex;
    }

    public LetterModel getModel() {
        return this.model;
    }

    public void setModel(TouTouLetter model) {
        this.model = model;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginleft) {
        this.marginLeft = marginleft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public void setTitleFontSize(int titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    public int getBodyFontSize() {
        return this.bodyFontSize;
    }

    public void setBodyFontSize(int bodyFontSize) {
        this.bodyFontSize = bodyFontSize;
    }

    public String getDocumentDir() {
        return this.documentDir;
    }

    public void setDocumentDir(String documentDir) {
        this.documentDir = documentDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

