/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PrintablePanel
extends JPanel
implements Printable {
    private String patientName;
    private int height;

    public void printPanel(PageFormat pageFormat, int numOfCopies, boolean useDialog, String name, int height) {
        this.patientName = name + " \u30ab\u30eb\u30c6";
        this.height = height;
        boolean buffered = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (pj != null) {
            pj.setCopies(numOfCopies);
            pj.setJobName(this.patientName + " by Dolphin");
            pj.setPrintable(this, pageFormat);
            if (useDialog) {
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException printErr) {
                        JOptionPane.showMessageDialog(null, "\u5370\u5237\u3067\u304d\u307e\u305b\u3093\u3002\n\u30d7\u30ea\u30f3\u30bf\u306e\u8a2d\u5b9a\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n" + printErr.getMessage(), "\u30a8\u30e9\u30fc", 0);
                    }
                }
            } else {
                try {
                    pj.print();
                }
                catch (PrinterException printErr) {
                    JOptionPane.showMessageDialog(null, "\u5370\u5237\u3067\u304d\u307e\u305b\u3093\u3002\n\u30d7\u30ea\u30f3\u30bf\u306e\u8a2d\u5b9a\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n" + printErr.getMessage(), "\u30a8\u30e9\u30fc", 0);
                }
            }
        }
        this.setDoubleBuffered(buffered);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        double scaledComponentHeight;
        int totalNumPages;
        Graphics2D g2 = (Graphics2D)g;
        Font f = new Font("Courier", 2, 9);
        g2.setFont(f);
        g2.setPaint(Color.black);
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDescent = g2.getFontMetrics().getDescent();
        double footerHeight = fontHeight;
        double pageHeight = pf.getImageableHeight() - footerHeight;
        double pageWidth = pf.getImageableWidth();
        double componentHeight = this.height == 0 ? this.getSize().getHeight() : (double)this.height;
        double componentWidth = this.getSize().getWidth();
        double scale = 1.0;
        if (componentWidth >= pageWidth) {
            scale = pageWidth / componentWidth;
        }
        if (pi >= (totalNumPages = (int)Math.ceil((scaledComponentHeight = componentHeight * scale) / pageHeight))) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        String footerString = this.patientName + "  Page: " + (pi + 1) + " of " + totalNumPages;
        int strW = SwingUtilities.computeStringWidth(g2.getFontMetrics(), footerString);
        g2.drawString(footerString, (int)pageWidth / 2 - strW / 2, (int)(pageHeight + (double)fontHeight - (double)fontDescent));
        g2.translate(0.0, 0.0);
        g2.translate(0.0, (double)(-pi) * pageHeight);
        if (pi == totalNumPages - 1) {
            g2.setClip(0, (int)(pageHeight * (double)pi), (int)Math.ceil(pageWidth), (int)(scaledComponentHeight - pageHeight * (double)(totalNumPages - 1)));
        } else {
            g2.setClip(0, (int)(pageHeight * (double)pi), (int)Math.ceil(pageWidth), (int)Math.ceil(pageHeight));
        }
        g2.scale(scale, scale);
        boolean wasBuffered = this.isDoubleBuffered();
        this.paint(g2);
        this.setDoubleBuffered(wasBuffered);
        return 0;
    }
}

