/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import open.dolphin.log.LogWriter;

public class ProxyPropertyChangeListener {
    public static PropertyChangeListener create(Object target, String methodName) {
        return ProxyPropertyChangeListener.create(target, methodName, new Class[]{Object.class});
    }

    public static PropertyChangeListener create(final Object target, final String methodName, final Class[] paramTypes) {
        Class<PropertyChangeListener> cls = PropertyChangeListener.class;
        ClassLoader cl = cls.getClassLoader();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Object result = null;
                PropertyChangeEvent e = (PropertyChangeEvent)args[0];
                Object newValue = e.getNewValue();
                try {
                    Method targetMethod = target.getClass().getMethod(methodName, paramTypes);
                    result = targetMethod.invoke(target, newValue);
                }
                catch (IllegalArgumentException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (SecurityException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (InvocationTargetException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (IllegalAccessException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                catch (NoSuchMethodException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                return result;
            }
        };
        return (PropertyChangeListener)Proxy.newProxyInstance(cl, new Class[]{cls}, handler);
    }
}

