/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.diagnosis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.IStampModelEditor;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.order.DiagnosisStateMgr;
import open.dolphin.order.RegisteredDiagnosisTransferHandler;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectTableModel;
import open.dolphin.table.OddEvenRowRendererWithExpire;
import open.dolphin.utils.CombinedStringParser;

public class DiagnosisTablePanel
extends JPanel
implements PropertyChangeListener {
    private static final String MODIFIER_CODE = "ZZZ";
    private static final String HAND_CODE = "0000999";
    private static final int CODE_COL = 0;
    private static final int NAME_COL = 1;
    private static final int ALIAS_COL = 2;
    private static final int[] DIAGNOSIS_TABLE_COLUMN_WIDTHS = new int[]{150, 200, 200};
    private static final String TOOLTIP_TABLE = "\u30b3\u30fc\u30c9\u306e\u30ab\u30e9\u30e0\u3067 Drag & Drop \u3067\u9806\u756a\u3092\u5165\u308c\u66ff\u3048\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059";
    private static final String SELECTED_ITEM_PROP = "selectedItemProp";
    private static final int COMBINED_FIELD_LENGTH = 20;
    private ObjectTableModel tableModel;
    private IStampModelEditor context;
    private DiagnosisStateMgr curState;
    private JPanel btnPanel;
    private JButton clearButton;
    private JTextField combinedDiagnosis;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel p;
    private JButton removeButton;
    private JScrollPane scroller;
    private JLabel stateLabel;
    private JTable table;

    public DiagnosisTablePanel(IStampModelEditor context) {
        super(new BorderLayout());
        this.initComponents();
        this.setContext(context);
        String[] diganosisColumns = new String[]{"\u30b3\u30fc\u30c9", "\u75be\u60a3\u540d/\u4fee\u98fe\u8a9e", "\u30a8\u30a4\u30ea\u30a2\u30b9"};
        this.tableModel = new ObjectTableModel(diganosisColumns, 0){

            @Override
            public boolean isCellEditable(int row, int col) {
                boolean ret = false;
                RegisteredDiagnosisModel model = (RegisteredDiagnosisModel)this.getObject(row);
                if (col == 1) {
                    if (model == null) {
                        ret = true;
                    } else if (!model.getDiagnosisCode().startsWith(DiagnosisTablePanel.MODIFIER_CODE)) {
                        ret = true;
                    }
                } else if (col == 2 && model != null && !model.getDiagnosisCode().startsWith(DiagnosisTablePanel.MODIFIER_CODE)) {
                    ret = true;
                }
                return ret;
            }

            @Override
            public Object getValueAt(int row, int col) {
                RegisteredDiagnosisModel model = (RegisteredDiagnosisModel)this.getObject(row);
                if (model == null) {
                    return null;
                }
                String ret = null;
                switch (col) {
                    case 0: {
                        ret = model.getDiagnosisCode();
                        break;
                    }
                    case 1: {
                        ret = model.getDiagnosisName();
                        break;
                    }
                    case 2: {
                        ret = model.getDiagnosisAlias();
                    }
                }
                return ret;
            }

            @Override
            public void setValueAt(Object o, int row, int col) {
                if (o == null) {
                    return;
                }
                int index = ((String)o).indexOf(44);
                if (index > 0) {
                    return;
                }
                RegisteredDiagnosisModel model = (RegisteredDiagnosisModel)this.getObject(row);
                String value = (String)o;
                switch (col) {
                    case 1: {
                        if (value.equals("")) break;
                        if (model != null) {
                            if (model.getDiagnosis().equals(value)) break;
                            model.setDiagnosis(value);
                            model.setDiagnosisCode(DiagnosisTablePanel.HAND_CODE);
                            this.fireTableCellUpdated(row, col);
                            break;
                        }
                        model = new RegisteredDiagnosisModel();
                        model.setDiagnosis(value);
                        model.setDiagnosisCode(DiagnosisTablePanel.HAND_CODE);
                        this.addRow(model);
                        DiagnosisTablePanel.this.curState.processEvent(DiagnosisStateMgr.Event.ADDED);
                        break;
                    }
                    case 2: {
                        if (model == null) break;
                        String test = model.getDiagnosis();
                        int idx = test.indexOf(44);
                        if (idx > 0) {
                            test = test.substring(0, idx);
                            test = test.trim();
                        }
                        if (value.equals("")) {
                            model.setDiagnosis(test);
                            break;
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(test);
                        sb.append(",");
                        sb.append(value);
                        model.setDiagnosis(sb.toString());
                    }
                }
            }
        };
        this.table.setModel(this.tableModel);
        this.table.setTransferHandler(new RegisteredDiagnosisTransferHandler(this));
        this.table.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int ctrlMask = 128;
                int action = (e.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, action);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        ListSelectionModel m = this.table.getSelectionModel();
        m.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DiagnosisTablePanel.this.curState.processEvent(DiagnosisStateMgr.Event.SELECTED);
                }
            }
        });
        this.table.setToolTipText(TOOLTIP_TABLE);
        this.table.setDefaultRenderer(Object.class, new OddEvenRowRendererWithExpire());
        TableColumn column = this.table.getColumnModel().getColumn(1);
        JTextField nametf = new JTextField();
        nametf.addFocusListener(AutoKanjiListener.getInstance());
        DefaultCellEditor nameEditor = new DefaultCellEditor(nametf);
        int clickCountToStart = GlobalVariables.getPreferences().getInt("diagnosis.table.clickCountToStart", 2);
        nameEditor.setClickCountToStart(clickCountToStart);
        column.setCellEditor(nameEditor);
        column = this.table.getColumnModel().getColumn(2);
        JTextField aliastf = new JTextField();
        aliastf.addFocusListener(AutoRomanListener.getInstance());
        DefaultCellEditor aliasEditor = new DefaultCellEditor(aliastf);
        aliasEditor.setClickCountToStart(clickCountToStart);
        column.setCellEditor(aliasEditor);
        int len = DIAGNOSIS_TABLE_COLUMN_WIDTHS.length;
        for (int i = 0; i < len; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(DIAGNOSIS_TABLE_COLUMN_WIDTHS[i]);
        }
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 0));
        this.btnPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.combinedDiagnosis.setColumns(20);
        this.p.setLayout(new FlowLayout(0));
        this.btnPanel.add(Box.createHorizontalGlue());
        this.btnPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.btnPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        if (this.getContext().getContext().getOkButton() != null) {
            this.btnPanel.add(this.getContext().getContext().getOkButton());
        }
        this.curState = new DiagnosisStateMgr(this.removeButton, this.clearButton, this.stateLabel, this.tableModel, this.table, this.getContext());
        this.curState.enter();
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.add((Component)this.scroller, "Center");
        this.add((Component)this.btnPanel, "South");
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.btnPanel = new JPanel();
        this.removeButton = new JButton();
        this.clearButton = new JButton();
        this.p = new JPanel();
        this.combinedDiagnosis = new JTextField();
        this.stateLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setName("table");
        this.scroller.setViewportView(this.table);
        this.btnPanel.setName("btnPanel");
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/del_16.gif")));
        this.removeButton.setToolTipText("\u9078\u629e\u3057\u305f\u50b7\u75c5\u540d\u3092\u524a\u9664\u3057\u307e\u3059");
        this.removeButton.setEnabled(false);
        this.removeButton.setName("removeButton");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/remov_16.gif")));
        this.clearButton.setToolTipText("\u30c6\u30fc\u30d6\u30eb\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059");
        this.clearButton.setEnabled(false);
        this.clearButton.setName("clearButton");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisTablePanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.p.setName("p");
        this.combinedDiagnosis.setEditable(false);
        this.combinedDiagnosis.setToolTipText("\u30c6\u30fc\u30d6\u30eb\u306e\u884c\u3092\u9023\u7d50\u3057\u3066\u4fee\u98fe\u8a9e\u4ed8\u304d\u306e\u50b7\u75c5\u540d\u306b\u3057\u307e\u3059");
        this.combinedDiagnosis.setName("combinedDiagnosis");
        this.stateLabel.setName("stateLabel");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/about_16.gif")));
        this.jLabel2.setName("jLabel2");
        this.jLabel1.setText("\u9023\u7d50\u3057\u305f\u50b7\u75c5\u540d:");
        this.jLabel1.setName("jLabel1");
        GroupLayout pLayout = new GroupLayout(this.p);
        this.p.setLayout(pLayout);
        pLayout.setHorizontalGroup(pLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.combinedDiagnosis, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stateLabel, -2, 162, -2).addContainerGap(238, Short.MAX_VALUE)));
        pLayout.setVerticalGroup(pLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pLayout.createSequentialGroup().addContainerGap().addGroup(pLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, 19, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, pLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.combinedDiagnosis, -1, 19, Short.MAX_VALUE)).addComponent(this.stateLabel, GroupLayout.Alignment.LEADING, -1, 19, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout btnPanelLayout = new GroupLayout(this.btnPanel);
        this.btnPanel.setLayout(btnPanelLayout);
        btnPanelLayout.setHorizontalGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, btnPanelLayout.createSequentialGroup().addComponent(this.p, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addContainerGap()));
        btnPanelLayout.setVerticalGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btnPanelLayout.createSequentialGroup().addGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(btnPanelLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(btnPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.clearButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(btnPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.p, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnPanel, -1, -1, Short.MAX_VALUE).addComponent(this.scroller, -1, 734, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scroller, -2, 137, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.tableModel.clear();
        this.combinedDiagnosis.setText("");
        this.curState.processEvent(DiagnosisStateMgr.Event.CLEARED);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        this.tableModel.removeRow(row);
        this.redraw();
        this.curState.processEvent(DiagnosisStateMgr.Event.DELETED);
    }

    public void clear() {
        this.tableModel.clear();
    }

    public IStampModelEditor getContext() {
        return this.context;
    }

    public void setContext(IStampModelEditor context) {
        this.context = context;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        MasterItem item;
        String prop = e.getPropertyName();
        if (prop.equals(SELECTED_ITEM_PROP) && (item = (MasterItem)e.getNewValue()) != null) {
            RegisteredDiagnosisModel model = new RegisteredDiagnosisModel();
            model.setDiagnosis(item.getName());
            model.setDiagnosisCode(item.getCode());
            model.setDiagnosisCodeSystem(item.getMasterTableId());
            this.tableModel.addRow(model);
            this.redraw();
            this.curState.processEvent(DiagnosisStateMgr.Event.ADDED);
        }
    }

    public void redraw() {
        if (this.hasModifier()) {
            CombinedStringParser sb = new CombinedStringParser();
            int count = this.tableModel.getDataSize();
            for (int i = 0; i < count; ++i) {
                RegisteredDiagnosisModel diag = (RegisteredDiagnosisModel)this.tableModel.getObject(i);
                sb.add(diag.getDiagnosis());
            }
            this.combinedDiagnosis.setText(sb.toPlainString());
        } else {
            this.combinedDiagnosis.setText("");
        }
    }

    private boolean hasModifier() {
        boolean hasModifier = false;
        int count = this.tableModel.getDataSize();
        for (int i = 0; i < count; ++i) {
            RegisteredDiagnosisModel diag = (RegisteredDiagnosisModel)this.tableModel.getObject(i);
            if (!diag.getDiagnosisCode().startsWith(MODIFIER_CODE)) continue;
            hasModifier = true;
            break;
        }
        return hasModifier;
    }

    public Object getValue() {
        if (this.hasModifier()) {
            return this.getValue1();
        }
        return this.getValue2();
    }

    private Object getValue1() {
        RegisteredDiagnosisModel diagnosis = null;
        CombinedStringParser combinedCode = new CombinedStringParser();
        CombinedStringParser combinedName = new CombinedStringParser();
        int count = this.tableModel.getDataSize();
        for (int i = 0; i < count; ++i) {
            RegisteredDiagnosisModel diag = (RegisteredDiagnosisModel)this.tableModel.getObject(i);
            String diagCode = diag.getDiagnosisCode();
            if (!diagCode.startsWith(MODIFIER_CODE)) {
                diagnosis = new RegisteredDiagnosisModel();
                diagnosis.setDiagnosisCodeSystem(diag.getDiagnosisCodeSystem());
            } else {
                diagCode = diagCode.substring(MODIFIER_CODE.length());
            }
            combinedCode.add(diagCode);
            combinedName.add(diag.getDiagnosis());
        }
        if (diagnosis != null && combinedName.size() > 0 && combinedCode.size() > 0) {
            diagnosis.setDiagnosis(combinedName.toCombinedString());
            diagnosis.setDiagnosisCode(combinedCode.toCombinedString());
            ArrayList<RegisteredDiagnosisModel> result = new ArrayList<RegisteredDiagnosisModel>(1);
            result.add(diagnosis);
            return result;
        }
        return null;
    }

    private Object getValue2() {
        return this.tableModel.getObjectList();
    }

    public void setValue(Object[] o) {
    }
}

