/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.transform.TransformerException;
import open.dolphin.client.AbstractStampBox;
import open.dolphin.client.AspStampBox;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.DefaultStampTreeXmlBuilder;
import open.dolphin.client.IMainTool;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.editor.stamp.EditorSetPanel;
import open.dolphin.client.editor.stamp.StampImporter;
import open.dolphin.client.editor.stamp.StampPublisher;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeXmlDirector;
import open.dolphin.client.editor.stamp.UserStampBox;
import open.dolphin.client.stamp.convert.StampConverter;
import open.dolphin.component.TabTransferHandler;
import open.dolphin.container.Pair;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PublishedTreeModel;
import open.dolphin.infomodel.StampTreeModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.FileOpenDialog;
import open.dolphin.utils.FileTool;
import org.xml.sax.SAXException;

public class StampBoxFrame
extends JFrame
implements IMainTool {
    private static final String NAME = "\u30b9\u30bf\u30f3\u30d7\u7bb1";
    private final int DEFAULT_WIDTH = 320;
    private final int DEFAULT_HEIGHT = 690;
    private final int IMPORT_TREE_OFFSET = 1;
    private AbstractStampBox userBox;
    private AbstractStampBox curBox;
    private List<Long> importedTreeList;
    private EditorSetPanel editors;
    private EditorValueListener editorValueListener;
    private boolean editing;
    private Point stampBoxLoc;
    private int stampBoxWidth;
    private int stampBoxHeight;
    private BlockGlass glass;
    private List<IStampTreeModel> stampTreeModels;
    private String name;
    private IMainWindow context;
    private JPanel cmdPanel;
    private JPanel content;
    private JLabel curBoxInfo;
    private JButton fileExportButton;
    private JButton fileImportButton;
    private JButton importBtn;
    private JTabbedPane parentBox;
    private JButton publishBtn;
    private JPanel stampBoxPanel;
    private JToggleButton toolBtn;

    public StampBoxFrame() {
        this.setName(NAME);
        this.importedTreeList = new ArrayList<Long>(5);
        this.initComponents();
    }

    private void initComponents() {
        this.content = new JPanel();
        this.stampBoxPanel = new JPanel();
        this.parentBox = new JTabbedPane();
        this.cmdPanel = new JPanel();
        this.toolBtn = new JToggleButton();
        this.publishBtn = new JButton();
        this.importBtn = new JButton();
        this.fileExportButton = new JButton();
        this.fileImportButton = new JButton();
        this.curBoxInfo = new JLabel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StampBoxFrame.this.formWindowClosing(evt);
            }
        });
        this.content.setName("content");
        this.content.setLayout(new BorderLayout());
        this.stampBoxPanel.setName("stampBoxPanel");
        this.stampBoxPanel.setLayout(new BorderLayout());
        this.parentBox.setTabPlacement(3);
        this.parentBox.setName("parentBox");
        this.parentBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StampBoxFrame.this.parentBoxStateChanged(evt);
            }
        });
        this.stampBoxPanel.add((Component)this.parentBox, "Center");
        this.cmdPanel.setName("cmdPanel");
        this.cmdPanel.setLayout(new FlowLayout(0, 0, 0));
        this.toolBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/tools_24.gif")));
        this.toolBtn.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u30e1\u30fc\u30ab\u3092\u8d77\u52d5\u3057\u307e\u3059");
        this.toolBtn.setName("toolBtn");
        this.toolBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StampBoxFrame.this.toolBtnActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.toolBtn);
        this.publishBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/exp_24.gif")));
        this.publishBtn.setToolTipText("\"\u30b9\u30bf\u30f3\u30d7\u306e\u516c\u958b\u3092\u7ba1\u7406\u3092\u3057\u307e\u3059");
        this.publishBtn.setName("publishBtn");
        this.publishBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StampBoxFrame.this.publishBtnActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.publishBtn);
        this.importBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/impt_24.gif")));
        this.importBtn.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u3092\u7ba1\u7406\u3092\u3057\u307e\u3059");
        this.importBtn.setName("importBtn");
        this.importBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StampBoxFrame.this.importBtnActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.importBtn);
        this.fileExportButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/save_24.gif")));
        this.fileExportButton.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u3092\u30d5\u30a1\u30a4\u30eb\u3078\u66f8\u304d\u51fa\u3057\u307e\u3059");
        this.fileExportButton.setName("fileExportButton");
        this.fileExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StampBoxFrame.this.fileExportButtonActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.fileExportButton);
        this.fileImportButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/move_24.gif")));
        this.fileImportButton.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u3092\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u8aad\u307f\u8fbc\u307f\u307e\u3059");
        this.fileImportButton.setName("fileImportButton");
        this.fileImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StampBoxFrame.this.fileImportButtonActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.fileImportButton);
        this.curBoxInfo.setFont(new Font("Dialog", 0, 10));
        this.curBoxInfo.setName("curBoxInfo");
        this.cmdPanel.add(this.curBoxInfo);
        this.stampBoxPanel.add((Component)this.cmdPanel, "North");
        this.content.add((Component)this.stampBoxPanel, "Center");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.content, -1, 363, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.content, -1, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void toolBtnActionPerformed(ActionEvent evt) {
        if (!this.editing) {
            this.startStampMake();
            this.editing = true;
        } else {
            this.stopStampMake();
            this.editing = false;
        }
    }

    private void publishBtnActionPerformed(ActionEvent evt) {
        this.publishStamp();
    }

    private void importBtnActionPerformed(ActionEvent evt) {
        this.importStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileExportButtonActionPerformed(ActionEvent evt) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            this.exportStampToFile();
        }
        finally {
            this.setCursor(currentCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileImportButtonActionPerformed(ActionEvent evt) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            this.importStampFromFile();
        }
        finally {
            this.setCursor(currentCursor);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.editing) {
            this.toolBtn.doClick();
        } else {
            this.setVisible(false);
        }
    }

    private void parentBoxStateChanged(ChangeEvent evt) {
        this.boxChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    public List<IStampTreeModel> getStampTreeModels() {
        return this.stampTreeModels;
    }

    public JTabbedPane getParentBox() {
        return this.parentBox;
    }

    private void setStampTreeModels(List<IStampTreeModel> stampTreeModels) {
        this.stampTreeModels = stampTreeModels;
    }

    private AbstractStampBox getCurrentBox() {
        return this.curBox;
    }

    private void setCurrentBox(AbstractStampBox curBox) {
        this.curBox = curBox;
    }

    public AbstractStampBox getUserStampBox() {
        return this.userBox;
    }

    public JFrame getFrame() {
        return this;
    }

    public List<Long> getImportedTreeList() {
        return this.importedTreeList;
    }

    public BlockGlass getBlockGlass() {
        return this.glass;
    }

    @Override
    public Callable<Boolean> getStartingTask() {
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    long userPk = GlobalVariables.getUserModel().getId();
                    RemoteStampDelegater stampDel = new RemoteStampDelegater();
                    List<IStampTreeModel> treeList = stampDel.getTrees(userPk);
                    if (!stampDel.isNoError()) {
                        return new Boolean(false);
                    }
                    boolean hasTree = false;
                    if (treeList != null && treeList.size() > 0) {
                        for (IStampTreeModel tree : treeList) {
                            long id;
                            if (tree == null || (id = tree.getUser().getId()) != userPk || !(tree instanceof StampTreeModel)) continue;
                            hasTree = true;
                            break;
                        }
                    }
                    if (!hasTree) {
                        treeList.add(0, StampBoxFrame.this.createStampTreeModel(StampBoxFrame.this.getSeedStamp()));
                    }
                    StampBoxFrame.this.setStampTreeModels(treeList);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
        return task;
    }

    @Override
    public void start() {
        if (this.stampTreeModels == null) {
            throw new RuntimeException("Fatal error: StampTreeModel is null at start.");
        }
        String title = GlobalConstants.getFrameTitle(this.getName());
        Rectangle setBounds = new Rectangle(0, 0, 1000, 690);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int defaultX = (screenSize.width - setBounds.width) / 2;
        int defaultY = (screenSize.height - setBounds.height) / 2;
        int defaultWidth = setBounds.width;
        int defaultHeight = setBounds.height;
        setBounds = new Rectangle(defaultX, defaultY, defaultWidth, defaultHeight);
        int x = defaultX + defaultWidth - 320;
        int y = defaultY;
        int width = 320;
        int height = 690;
        this.setTitle(title);
        ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
        this.setIconImage(icon.getImage());
        this.setSize(new Dimension(this.stampBoxWidth, this.stampBoxHeight));
        Dimension dim = new Dimension(350, 690);
        this.setMinimumSize(dim);
        this.glass = new BlockGlass();
        this.setGlassPane(this.glass);
        ComponentMemory cm = new ComponentMemory(this, new Point(x, y), new Dimension(width, height), this);
        cm.setToPreferenceBounds();
        for (IStampTreeModel model : this.stampTreeModels) {
            if (model == null) continue;
            if (model.getUser().getId() == GlobalVariables.getUserModel().getId() && model instanceof StampTreeModel) {
                this.userBox = new UserStampBox(this, model);
                this.userBox.setTransferHandler(new TabTransferHandler());
                this.parentBox.addTab("\u500b\u4eba\u7528", this.userBox);
                continue;
            }
            if (!(model instanceof PublishedTreeModel)) continue;
            this.importPublishedTree(model);
        }
        this.stampTreeModels.clear();
        for (int i = 0; i < this.parentBox.getTabCount(); ++i) {
            AbstractStampBox box = (AbstractStampBox)this.parentBox.getComponentAt(i);
            this.parentBox.setToolTipTextAt(i, box.getInfo());
        }
        this.setCurrentBox(this.userBox);
        this.userBox.addChangeListener(new TabChangeListener());
        this.setContentPane(this.content);
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String name1 = this.getClass().getName();
        int index = prefs.getInt(name1 + "_parentBox", 0);
        index = index >= 0 && index <= this.parentBox.getTabCount() - 1 ? index : 0;
        this.parentBox.setSelectedIndex(index);
        index = prefs.getInt(name1 + "_stampBox", 0);
        index = index >= 0 && index <= this.userBox.getTabCount() - 1 ? index : 0;
        int n = index = index == 3 ? 0 : index;
        if (this.userBox.getTabCount() != 0) {
            this.userBox.setSelectedIndex(index);
        }
        this.boxChanged();
    }

    private void boxChanged() {
        int index = this.parentBox.getSelectedIndex();
        this.setCurrentBox((AbstractStampBox)this.parentBox.getComponentAt(index));
        String info = this.getCurrentBox().getInfo();
        this.curBoxInfo.setText(info);
        if (this.getCurrentBox() == this.userBox) {
            this.publishBtn.setEnabled(true);
            int index2 = this.userBox.getSelectedIndex();
            boolean enabled = this.userBox.isHasEditor(index2);
            this.toolBtn.setEnabled(enabled);
        } else {
            this.toolBtn.setEnabled(false);
            this.publishBtn.setEnabled(false);
        }
    }

    private void enabledImportBox(boolean enabled) {
        int cnt = this.parentBox.getTabCount();
        for (int i = 0; i < cnt; ++i) {
            if ((JTabbedPane)this.parentBox.getComponentAt(i) == this.userBox) continue;
            this.parentBox.setEnabledAt(i, enabled);
        }
    }

    public boolean update() {
        return false;
    }

    private void startStampMake() {
        if (!this.editing) {
            this.stampBoxLoc = this.getLocation();
            this.stampBoxWidth = this.getWidth();
            this.stampBoxHeight = this.getHeight();
            Dimension dim = new Dimension(1000, 690);
            this.setMinimumSize(dim);
            this.enabledImportBox(false);
            int index = this.userBox.getSelectedIndex();
            StampTree tree = this.userBox.getStampTree(index);
            String entity = tree.getEntity();
            this.userBox.setHasNoEditorEnabled(false);
            List<StampTree> allTrees = this.userBox.getAllTrees();
            this.editors = new EditorSetPanel();
            for (StampTree st : allTrees) {
                st.addTreeSelectionListener(this.editors);
            }
            this.editorValueListener = new EditorValueListener();
            this.editors.addPropertyChangeListener("editorValueProp", this.editorValueListener);
            this.editors.show(entity);
            this.content.removeAll();
            this.content.add((Component)this.editors, "Center");
            this.content.add((Component)this.stampBoxPanel, "East");
            this.stampBoxPanel.setPreferredSize(new Dimension(300, 690));
            this.editors.setPreferredSize(new Dimension(724, 690));
            this.content.setPreferredSize(new Dimension(1000, 690));
            this.content.revalidate();
            this.setVisible(false);
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            String name1 = this.getClass().getName();
            int locX = prefs.getInt(name1 + ".stampmMaker.x", 0);
            int locY = prefs.getInt(name1 + ".stampmMaker.y", 0);
            int width = prefs.getInt(name1 + ".stampmMaker.width", 0);
            int height = prefs.getInt(name1 + ".stampmMaker.height", 0);
            if (width == 0 || height == 0) {
                this.pack();
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (screen.width - this.getWidth()) / 2;
                int y = (screen.height - this.getHeight()) / 2;
                this.setLocation(x, y);
            } else {
                this.setLocation(locX, locY);
                this.setSize(width, height);
            }
            this.setVisible(true);
            this.editing = true;
            this.toolBtn.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u30e1\u30fc\u30ab\u3092\u7d42\u4e86\u3057\u307e\u3059");
            this.publishBtn.setEnabled(false);
            this.importBtn.setEnabled(false);
        }
    }

    private void stopStampMake() {
        Dimension dim = new Dimension(350, 690);
        this.setMinimumSize(dim);
        if (this.editing) {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            String name1 = this.getClass().getName();
            prefs.putInt(name1 + ".stampmMaker.x", this.getLocation().x);
            prefs.putInt(name1 + ".stampmMaker.y", this.getLocation().y);
            prefs.putInt(name1 + ".stampmMaker.width", this.getWidth());
            prefs.putInt(name1 + ".stampmMaker.height", this.getHeight());
            this.editors.close();
            this.editors.removePropertyChangeListener("editorValueProp", this.editorValueListener);
            List<StampTree> allTrees = this.userBox.getAllTrees();
            for (StampTree st : allTrees) {
                st.removeTreeSelectionListener(this.editors);
            }
            this.content.removeAll();
            this.content.add((Component)this.stampBoxPanel, "Center");
            this.editors = null;
            this.editorValueListener = null;
            this.userBox.setHasNoEditorEnabled(true);
            this.content.revalidate();
            this.setLocation(this.stampBoxLoc);
            this.setSize(new Dimension(this.stampBoxWidth, this.stampBoxHeight));
            this.editing = false;
            this.toolBtn.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u30e1\u30fc\u30ab\u3092\u8d77\u52d5\u3057\u307e\u3059");
            this.publishBtn.setEnabled(true);
            this.importBtn.setEnabled(true);
            this.enabledImportBox(true);
        }
    }

    private void publishStamp() {
        StampPublisher publisher = new StampPublisher(this);
        publisher.start();
    }

    private void importStamp() {
        StampImporter importer = new StampImporter(this);
        importer.start();
    }

    private void exportStampToFile() {
        FileOpenDialog dialog1 = new FileOpenDialog(this, "", 1, "stamp");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb", "stamp");
        dialog1.addChoosableFileFilter(filter);
        if (dialog1.open() == 0) {
            try {
                RemoteStampDelegater delegator = new RemoteStampDelegater();
                FileTool.stringToFile(dialog1.getPath(), StampConverter.buildStampXml(delegator, this.getStampTree()), "UTF-8");
                JOptionPane.showMessageDialog(null, "\u30d5\u30a1\u30a4\u30eb'" + dialog1.getPath() + "'\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3057\u305f\u3002", "\u78ba\u8a8d", 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void importStampFromFile() {
        FileOpenDialog dialog = new FileOpenDialog(this, "", 0, "stamp");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb", "stamp");
        dialog.addChoosableFileFilter(filter);
        if (dialog.open() == 0 && JOptionPane.showConfirmDialog(null, "\u30d5\u30a1\u30a4\u30eb'" + dialog.getPath() + "'\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002\n\u73fe\u5728\u306e\u30b9\u30bf\u30f3\u30d7\u306f\u5168\u3066\u7f6e\u304d\u63db\u3048\u3089\u308c\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) == 0) {
            try {
                RemoteStampDelegater delegator = new RemoteStampDelegater();
                this.importStampXml(delegator, FileTool.fileToString(dialog.getPath(), "UTF-8"));
                JOptionPane.showMessageDialog(null, "\u30b9\u30bf\u30f3\u30d7\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u5f8c\u306fOpenDolphin\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            catch (SAXException ex) {
                JOptionPane.showMessageDialog(null, "\u30d5\u30a1\u30a4\u30eb'" + dialog.getPath() + "'\u306f\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u306a\u3044\u3088\u3046\u3067\u3059\u3002\n" + ex.getMessage(), "\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
            }
            catch (TransformerException ex) {
                JOptionPane.showMessageDialog(null, "\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u306e XML \u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002\n" + ex.getMessage(), "\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc", 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void importPublishedTree(IStampTreeModel importTree) {
        String st = importTree.getName();
        for (int i = 0; i < this.parentBox.getComponentCount(); ++i) {
            String tst = this.parentBox.getTitleAt(i);
            if (!st.equals(tst)) continue;
            return;
        }
        AspStampBox aspBox = new AspStampBox(this, importTree);
        this.parentBox.addTab(importTree.getName(), aspBox);
        this.importedTreeList.add(new Long(importTree.getId()));
    }

    public void removeImportedTree(long removeId) {
        if (this.importedTreeList != null) {
            for (int i = 0; i < this.importedTreeList.size(); ++i) {
                Long id = this.importedTreeList.get(i);
                if (id != removeId) continue;
                this.parentBox.removeTabAt(i + 1);
                this.importedTreeList.remove(i);
                break;
            }
        }
    }

    @Override
    public void stop() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void enter() {
        this.toFront();
    }

    @Override
    public Callable<Boolean> getStoppingTask() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String name1 = this.getClass().getName();
        if (this.editing) {
            prefs.putInt(name1 + "_x", this.stampBoxLoc.x);
            prefs.putInt(name1 + "_y", this.stampBoxLoc.y);
            prefs.putInt(name1 + "_width", this.stampBoxWidth);
            prefs.putInt(name1 + "_height", this.stampBoxHeight);
        }
        prefs.putInt(name1 + "_parentBox", this.parentBox.getSelectedIndex());
        prefs.putInt(name1 + "_stampBox", this.userBox.getSelectedIndex());
        final IStampTreeModel treeModel = this.userBox.getStampTreeModel();
        String treeXml = this.getStampTree();
        treeModel.setTreeXml(treeXml);
        Callable<Boolean> longTask = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return StampBoxFrame.this.saveStampTreeModel(treeModel);
            }
        };
        return longTask;
    }

    private Boolean saveStampTreeModel(IStampTreeModel treeModel) {
        RemoteStampDelegater stampDel = new RemoteStampDelegater();
        stampDel.putTree(treeModel);
        boolean result = stampDel.isNoError();
        return new Boolean(result);
    }

    public StampTree getStampTree(String entity) {
        return this.getCurrentBox().getStampTree(entity);
    }

    public StampTree getStampTreeFromUserBox(String entity) {
        return this.getUserStampBox().getStampTree(entity);
    }

    public List<StampTree> getAllTrees() {
        return this.getCurrentBox().getAllTrees();
    }

    public List<StampTree> getAllPTrees() {
        AbstractStampBox stb = this.getCurrentBox();
        return stb.getAllPTrees();
    }

    private StampTreeModel createStampTreeModel(String stampXml) {
        FacilityModel facility = GlobalVariables.getUserModel().getFacility();
        StampTreeModel result = new StampTreeModel();
        result.initialize(GlobalVariables.getUserModel(), "\u500b\u4eba\u7528", "\u500b\u4eba\u7528\u306e\u30b9\u30bf\u30f3\u30d7\u30bb\u30c3\u30c8\u3067\u3059", facility.getFacilityName(), facility.getUrl(), stampXml);
        return result;
    }

    private String getSeedStamp() {
        String result = "";
        try {
            InputStream seedStamp = GlobalConstants.getResourceAsStream("stamptree-seed.xml");
            result = FileTool.streamToString(seedStamp, "UTF-8");
            seedStamp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void importStampXml(RemoteStampDelegater delegator, String stampSetXml) throws SAXException, IOException, TransformerException {
        List<Pair<Pair<String, String>, String>> stamps = StampConverter.extractStamps(stampSetXml);
        delegator.cleanStamp(GlobalVariables.getUserModel().getId());
        HashMap<String, String> convertIdMap = new HashMap<String, String>();
        for (int index = 0; index < stamps.size(); ++index) {
            Pair<Pair<String, String>, String> stamp = stamps.get(index);
            String newId = StampConverter.updateStamp(delegator, (String)((Pair)stamp.key).key, (String)((Pair)stamp.key).value, (String)stamp.value);
            if (newId.equals(((Pair)stamp.key).key)) continue;
            convertIdMap.put((String)((Pair)stamp.key).key, newId);
        }
        String originalTreeXml = StampConverter.extractStampTree(stampSetXml);
        String stampTreeXml = StampConverter.changeStampIds(originalTreeXml, convertIdMap);
        IStampTreeModel model = this.userBox.getStampTreeModel();
        model.setTreeXml(stampTreeXml);
        this.userBox = new UserStampBox(this, model);
        this.userBox.setTransferHandler(new TabTransferHandler());
        for (int index = this.parentBox.getTabCount() - 1; index >= 0; --index) {
            if (!this.parentBox.getTitleAt(index).equals("\u500b\u4eba\u7528")) continue;
            this.parentBox.setComponentAt(index, this.userBox);
            this.userBox.addChangeListener(new TabChangeListener());
        }
    }

    public String getStampTree() {
        List<StampTree> list = this.userBox.getAllTrees();
        if (list == null || list.size() == 0) {
            return "";
        }
        for (StampTree tree : list) {
            if (!tree.getTreeInfo().getEntity().equals("orcaSet")) continue;
            list.remove(tree);
            break;
        }
        DefaultStampTreeXmlBuilder builder = new DefaultStampTreeXmlBuilder();
        StampTreeXmlDirector director = new StampTreeXmlDirector(builder);
        return director.build(list);
    }

    class EditorValueListener
    implements PropertyChangeListener {
        EditorValueListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object obj = e.getNewValue();
            if (obj != null && obj instanceof ModuleModel) {
                ModuleModel stamp = (ModuleModel)obj;
                String entity = stamp.getModuleInfo().getEntity();
                StampTree tree = StampBoxFrame.this.userBox.getStampTree(entity);
                try {
                    tree.addStamp(stamp, null);
                }
                catch (SQLException ex) {
                    Logger.getLogger(StampBoxFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                tree.saveStampTree();
            } else if (obj != null && obj instanceof ArrayList) {
                StampTree tree = StampBoxFrame.this.getStampTree("diagnosis");
                try {
                    tree.addDiagnosis((List)obj);
                }
                catch (SQLException ex) {
                    Logger.getLogger(StampBoxFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!StampBoxFrame.this.editing) {
                int index = StampBoxFrame.this.userBox.getSelectedIndex();
                StampTree tree = StampBoxFrame.this.userBox.getStampTree(index);
                tree.enter();
                boolean enabled = StampBoxFrame.this.userBox.isHasEditor(index);
                StampBoxFrame.this.toolBtn.setEnabled(enabled);
            } else {
                int index = StampBoxFrame.this.userBox.getSelectedIndex();
                StampTree tree = StampBoxFrame.this.userBox.getStampTree(index);
                if (StampBoxFrame.this.editors != null && !tree.getEntity().equals("text")) {
                    StampBoxFrame.this.editors.show(tree.getEntity());
                }
            }
        }
    }
}

