/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestdocument;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import open.dolphin.client.labotestdocument.LaboTestItemID;
import open.dolphin.client.labotestdocument.SimpleLaboSpecimen;
import open.dolphin.log.LogWriter;

public class AllLaboTest {
    private TreeMap<SimpleLaboSpecimen, TreeSet<LaboTestItemID>> allTests = new TreeMap();

    public void clear() {
        this.allTests.clear();
    }

    public void addSpecimen(SimpleLaboSpecimen specimen) {
        if (!this.allTests.containsKey(specimen)) {
            this.allTests.put(specimen, new TreeSet());
        }
    }

    public void addTestItem(SimpleLaboSpecimen specimen, LaboTestItemID testItem) {
        TreeSet<LaboTestItemID> treeSet = this.allTests.get(specimen);
        if (treeSet != null) {
            treeSet.add(testItem);
        } else {
            LogWriter.debug(AllLaboTest.class, specimen.getSpecimenName());
        }
    }

    public TreeMap getAllTests() {
        return this.allTests;
    }

    public int getRowCount() {
        int count = 0;
        for (SimpleLaboSpecimen sp : this.allTests.keySet()) {
            ++count;
            Iterator<LaboTestItemID> it = this.allTests.get(sp).iterator();
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        return count;
    }

    public void fillRow(Object[][] laboData, int startRow, int col) {
        for (SimpleLaboSpecimen sp : this.allTests.keySet()) {
            laboData[startRow++][col] = sp;
            for (LaboTestItemID id : this.allTests.get(sp)) {
                laboData[startRow++][col] = id.getItemName();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (SimpleLaboSpecimen sp : this.allTests.keySet()) {
            buf.append("\n");
            buf.append(sp.getSpecimenName());
            buf.append("\n");
            for (LaboTestItemID id : this.allTests.get(sp)) {
                buf.append(id.getItemName());
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

