/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import open.dolphin.delegater.BusinessDelegater;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.PublishedTreeModel;
import open.dolphin.infomodel.StampModel;
import open.dolphin.infomodel.StampTreeModel;
import open.dolphin.infomodel.SubscribedTreeModel;
import open.dolphin.project.GlobalVariables;
import open.dolphin.service.IStampService;
import open.dolphin.utils.GUIDGenerator;

public abstract class StampDelegater
extends BusinessDelegater {
    protected abstract IStampService getService() throws NamingException;

    public int cancelPublishedTree(StampTreeModel model) {
        try {
            return this.getService().cancelPublishedTree(model);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public StampTreeModel getAspTree(String treemanager) {
        try {
            return this.getService().getAspTree(treemanager);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public List<PublishedTreeModel> getPublishedTrees() {
        try {
            return this.getService().getPublishedTrees();
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public StampModel getStamp(String stampId) {
        try {
            return this.getService().getStamp(stampId);
        }
        catch (Exception e) {
            this.processError(e);
            return null;
        }
    }

    public List<StampModel> getStamp(List<ModuleInfoBean> list) {
        ArrayList<String> ids = new ArrayList<String>(list.size());
        for (ModuleInfoBean info : list) {
            ids.add(info.getStampId());
        }
        try {
            return this.getService().getStamp(ids);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public List<IStampTreeModel> getTrees(long userPk) {
        try {
            return this.getService().getTrees(userPk);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public String newStamp(String stampId, String entity, String stamp) {
        StampModel stampModel = new StampModel();
        stampModel.initialize(stampId, GlobalVariables.getUserModel().getId(), entity, stamp);
        try {
            return this.getService().putStamp(stampModel);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public String newStamp(String entity, String stamp) {
        StampModel stampModel = new StampModel();
        String stampId = GUIDGenerator.generate(stampModel);
        stampModel.initialize(stampId, GlobalVariables.getUserModel().getId(), entity, stamp);
        try {
            return this.getService().putStamp(stampModel);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public int publishTree(StampTreeModel model, byte[] publishBytes) {
        try {
            return this.getService().publishTree(model, publishBytes);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public List<String> putStamp(List<StampModel> list) {
        try {
            return this.getService().putStamp(list);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public String putStamp(StampModel model) {
        try {
            return this.getService().putStamp(model);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public long putTree(IStampTreeModel model) {
        try {
            return this.getService().putTree((StampTreeModel)model);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0L;
        }
    }

    public int removeStamp(String stampId) {
        try {
            return this.getService().removeStamp(stampId);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public int removeStamp(List<String> ids) {
        try {
            return this.getService().removeStamp(ids);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public void cleanStamp(long userId) {
        try {
            this.getService().cleanStamp(userId);
        }
        catch (NamingException ex) {
            this.processError(ex);
        }
    }

    public long saveAndPublishTree(StampTreeModel model, byte[] publishBytes) {
        try {
            return this.getService().saveAndPublishTree(model, publishBytes);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0L;
        }
    }

    public List<Long> subscribeTrees(List<SubscribedTreeModel> subscribeList) {
        try {
            return this.getService().subscribeTrees(subscribeList);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public int unsubscribeTrees(List<SubscribedTreeModel> removeList) {
        try {
            return this.getService().unsubscribeTrees(removeList);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public int updatePublishedTree(StampTreeModel model, byte[] publishBytes) {
        try {
            return this.getService().updatePublishedTree(model, publishBytes);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public String updateStamp(StampModel model, String stamp) {
        String targetID = model.getId();
        try {
            IStampService service = this.getService();
            StampModel currentModel = service.getStamp(targetID);
            if (currentModel != null) {
                currentModel.setXml(stamp);
                service.removeStamp(targetID);
                return service.putStamp(currentModel);
            }
        }
        catch (Exception ex) {
            this.processError(ex);
        }
        return null;
    }
}

