/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import javax.persistence.Transient;
import open.dolphin.infomodel.BeanUtils;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.KarteEntryBean;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

public class ModuleModel
extends KarteEntryBean {
    private ModuleInfoBean moduleInfo;
    private transient Blob beanBlob;
    private byte[] beanBytes;
    private DocumentModel document;
    @Transient
    private IInfoModel model;

    public ModuleModel() {
        this.setModuleInfo(new ModuleInfoBean());
    }

    public ModuleModel(IInfoModel model) {
        this.setModuleInfo(new ModuleInfoBean());
        this.setModel(model);
    }

    @Override
    public boolean search(DolphinQuery query) {
        if (((InfoModel)this.model).search(query)) {
            return true;
        }
        if (this.moduleInfo.search(query)) {
            return true;
        }
        return this.getXml().indexOf(query.what("keyword")) != -1;
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    public void setDocument(DocumentModel document) {
        this.document = document;
    }

    public void setModuleInfo(ModuleInfoBean moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public ModuleInfoBean getModuleInfo() {
        return this.moduleInfo;
    }

    public void setModel(IInfoModel model) {
        this.model = model;
    }

    public IInfoModel getModel() {
        return this.model;
    }

    public byte[] getBeanBytes() {
        return this.beanBytes;
    }

    public void setBeanBytes(byte[] beanBytes) {
        this.beanBytes = beanBytes;
        this.beanBlob = beanBytes == null ? null : new BlobImpl(beanBytes);
    }

    public Blob getBeanBlob() {
        return this.beanBlob;
    }

    public void setBeanBlob(Blob beanBlob) throws SQLException {
        if (beanBlob != null) {
            this.beanBlob = beanBlob;
            this.beanBytes = beanBlob.getBytes(1L, (int)beanBlob.length());
        }
    }

    public String getXml() {
        if (this.beanBytes != null) {
            try {
                return new String(this.getBeanBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    public void setXml(String xml) {
        if (xml != null) {
            try {
                this.beanBytes = xml.getBytes("UTF-8");
                this.beanBlob = this.beanBytes == null ? null : new BlobImpl(this.beanBytes);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public IInfoModel toInfoModel() {
        return (IInfoModel)BeanUtils.xmlDecode(this.getBeanBytes());
    }

    @Override
    public int compareTo(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            ModuleInfoBean moduleInfo1 = this.getModuleInfo();
            ModuleInfoBean moduleInfo2 = ((ModuleModel)other).getModuleInfo();
            return moduleInfo1.compareTo(moduleInfo2);
        }
        return -1;
    }

    private String DocumentModelToString(DocumentModel d) {
        if (d == null) {
            return "";
        }
        return Long.toString(d.getId());
    }

    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<ModuleModel document_id='" + this.DocumentModelToString(this.document) + "'>\n");
        super.serialize(result);
        if (this.moduleInfo != null) {
            this.moduleInfo.serialize(result);
        }
        result.append("<beanBytes>\n");
        result.append("<![CDATA[");
        result.append(this.getXml());
        result.append("]]>\n");
        result.append("</beanBytes>\n");
        result.append("</ModuleModel>\n");
    }
}

