/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.ExtRefModel;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.KarteEntryBean;
import org.hibernate.lob.BlobImpl;

public class SchemaModel
extends KarteEntryBean {
    private DocumentModel document;
    private transient Blob jpegBlob;
    private byte[] jpegBytes;
    private ExtRefModel extRef;
    @Transient
    private String fileName;
    @Transient
    private ImageIcon icon;
    @Transient
    private int imageNumber;

    public ExtRefModel getExtRef() {
        return this.extRef;
    }

    public void setExtRef(ExtRefModel val) {
        this.extRef = val;
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    public void setDocument(DocumentModel document) {
        this.document = document;
    }

    public byte[] getJpegBytes() {
        return this.jpegBytes;
    }

    public void setJpegBytes(byte[] jpegBytes) {
        this.jpegBytes = jpegBytes;
        if (jpegBytes == null) {
            jpegBytes = null;
        } else {
            this.jpegBlob = new BlobImpl(jpegBytes);
        }
    }

    public Blob getJpegBlob() {
        return this.jpegBlob;
    }

    public void setJpegBlob(Blob jpegBlob) throws SQLException {
        if (jpegBlob != null) {
            this.jpegBlob = jpegBlob;
            this.jpegBytes = jpegBlob.getBytes(1L, (int)jpegBlob.length());
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon val) {
        this.icon = val;
    }

    public int getImageNumber() {
        return this.imageNumber;
    }

    public void setImageNumber(int imageNumber) {
        this.imageNumber = imageNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String val) {
        this.fileName = val;
    }

    public IInfoModel getModel() {
        return this.getExtRef();
    }

    public void setModel(IInfoModel val) {
        this.setExtRef((ExtRefModel)val);
    }

    @Override
    public int compareTo(Object other) {
        int result = super.compareTo(other);
        if (result == 0) {
            int no1 = this.getImageNumber();
            int no2 = ((SchemaModel)other).getImageNumber();
            result = no1 - no2;
        }
        return result;
    }

    private String DocumentModelToString(DocumentModel d) {
        if (d == null) {
            return "";
        }
        return Long.toString(d.getId());
    }

    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<SchemaModel document_id='" + this.DocumentModelToString(this.document) + "'>\n");
        super.serialize(result);
        if (this.extRef != null) {
            this.extRef.serialize(result);
        }
        result.append("<jpegByte>\n");
        result.append(this.jpegBytes.toString());
        result.append("</jpegByte>\n");
        result.append("</SchemaModel>\n");
    }
}

