/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.order.MasterItemTransferable;
import open.dolphin.table.ObjectReflectTableModel;

public class MasterItemTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 4871088750931696219L;
    private DataFlavor masterItemFlavor = MasterItemTransferable.masterItemFlavor;
    private JTable sourceTable;
    private boolean shouldRemove;
    private int fromIndex;
    private int toIndex;

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.sourceTable = (JTable)c;
        ObjectReflectTableModel tableModel = (ObjectReflectTableModel)this.sourceTable.getModel();
        this.fromIndex = this.sourceTable.getSelectedRow();
        MasterItem dragItem = (MasterItem)tableModel.getObject(this.fromIndex);
        return dragItem != null ? new MasterItemTransferable(dragItem) : null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                MasterItem dropItem = (MasterItem)t.getTransferData(this.masterItemFlavor);
                JTable dropTable = (JTable)c;
                ObjectReflectTableModel tableModel = (ObjectReflectTableModel)dropTable.getModel();
                this.toIndex = dropTable.getSelectedRow();
                boolean bl = this.shouldRemove = dropTable == this.sourceTable;
                if (this.shouldRemove) {
                    tableModel.moveRow(this.fromIndex, this.toIndex);
                } else {
                    tableModel.addRow(this.toIndex, dropItem);
                }
                this.sourceTable.getSelectionModel().setSelectionInterval(this.toIndex, this.toIndex);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action != 2 || this.shouldRemove) {
            // empty if block
        }
        this.shouldRemove = false;
        this.fromIndex = -1;
        this.toIndex = -1;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        JTable dropTable = (JTable)c;
        ObjectReflectTableModel tableModel = (ObjectReflectTableModel)dropTable.getModel();
        if (tableModel.getObject(dropTable.getSelectedRow()) != null) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!this.masterItemFlavor.equals(flavors[i])) continue;
                return true;
            }
        }
        return false;
    }
}

