/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.List;
import open.dolphin.dto.PatientSearchSpec;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.service.remote.AbstractPatientModelFinder;
import open.dolphin.service.remote.AddressSearch;
import open.dolphin.service.remote.AllSerach;
import open.dolphin.service.remote.DateSearch;
import open.dolphin.service.remote.DigitSearch;
import open.dolphin.service.remote.EmailSearch;
import open.dolphin.service.remote.IdSearch;
import open.dolphin.service.remote.KanaSearch;
import open.dolphin.service.remote.NameSearch;
import open.dolphin.service.remote.RomanSearch;
import open.dolphin.service.remote.TelephoneSearch;
import open.dolphin.service.remote.ZipCodeSearch;
import org.hibernate.Session;

class PatientModelFinder {
    private AbstractPatientModelFinder finder;
    private PatientSearchSpec spec;

    public PatientModelFinder(PatientSearchSpec spec, Session session) {
        this.spec = spec;
        this.finder = this.createFinder(spec.getCode(), session);
    }

    private AbstractPatientModelFinder createFinder(int code, Session session) {
        switch (code) {
            case 7: {
                return new AddressSearch(session);
            }
            case 0: {
                return new AllSerach(session);
            }
            case 11: {
                return new DateSearch(session);
            }
            case 10: {
                return new DigitSearch(session);
            }
            case 8: {
                return new EmailSearch(session);
            }
            case 1: {
                return new IdSearch(session);
            }
            case 3: {
                return new KanaSearch(session);
            }
            case 2: {
                return new NameSearch(session);
            }
            case 4: {
                return new RomanSearch(session);
            }
            case 5: {
                return new TelephoneSearch(session);
            }
            case 6: {
                return new ZipCodeSearch(session);
            }
        }
        return new AllSerach(session);
    }

    public List<PatientModel> find(String fid) {
        return this.finder.find(fid, this.spec, false);
    }

    public List<PatientModel> find(String fid, boolean strict) {
        List<PatientModel> result = this.finder.find(fid, this.spec, strict);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result;
    }
}

