/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.table;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ObjectTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 38474601689966826L;
    private String[] columnNames;
    private String[] methodNames;
    private int startNumRows;
    private List objectList;

    public ObjectTableModel() {
    }

    public ObjectTableModel(String[] columnNames, int startNumRows) {
        this();
        this.columnNames = columnNames;
        this.startNumRows = startNumRows;
    }

    public ObjectTableModel(String[] columnNames, int startNumRows, String[] methodNames) {
        this(columnNames, startNumRows);
        this.methodNames = methodNames;
    }

    protected int getStartNumRows() {
        return this.startNumRows;
    }

    @Override
    public int getRowCount() {
        int size = this.getObjectCount();
        return size < this.getStartNumRows() ? this.getStartNumRows() : size;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object target = this.getObject(row);
        if (target != null && this.methodNames != null) {
            try {
                Method method = target.getClass().getMethod(this.methodNames[col], null);
                return method.invoke(target, (Object[])null);
            }
            catch (Exception e) {
                return null;
            }
        }
        return target;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public int getObjectCount() {
        return this.objectList == null ? 0 : this.objectList.size();
    }

    public Object getObject(int row) {
        return this.isValidRow(row) ? this.objectList.get(row) : null;
    }

    public boolean isValidRow(int row) {
        return this.objectList != null && row > -1 && row < this.objectList.size();
    }

    public void addRow(Object o) {
        if (this.objectList == null) {
            this.objectList = new ArrayList();
        }
        int index = this.objectList.size();
        this.objectList.add(o);
        this.fireTableRowsInserted(index, index);
    }

    public void insertRow(int index, Object o) {
        if (this.objectList == null) {
            this.objectList = new ArrayList();
        }
        if (index == 0 && this.objectList.isEmpty() || this.isValidRow(index)) {
            this.objectList.add(index, o);
            this.fireTableRowsInserted(index, index);
        }
    }

    public void moveRow(int from, int to) {
        if (!this.isValidRow(from) || !this.isValidRow(to)) {
            return;
        }
        if (from == to) {
            return;
        }
        Object o = this.objectList.remove(from);
        this.objectList.add(to, o);
        this.fireTableRowsUpdated(0, this.getObjectCount());
    }

    public void removeRow(int index) {
        if (this.isValidRow(index)) {
            this.objectList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void deleteRow(int index) {
        this.removeRow(index);
    }

    public void clear() {
        if (this.objectList == null) {
            return;
        }
        int size = this.objectList.size();
        size = size > 0 ? size - 1 : 0;
        this.objectList.clear();
        this.fireTableRowsDeleted(0, size);
    }

    public void setObjectList(List list) {
        if (this.objectList != null) {
            this.objectList.clear();
        }
        this.objectList = list;
        this.fireTableDataChanged();
    }

    public List getObjectList() {
        return this.objectList;
    }

    public int getDataSize() {
        return this.getObjectCount();
    }
}

