/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import open.dolphin.table.ITableSelectionListener;
import open.dolphin.table.ObjectReflectTableModel;

public class TableSelectionAdapter
implements ListSelectionListener,
MouseListener {
    private JTable table;
    private ObjectReflectTableModel<Object> tableModel;
    private ITableSelectionListener listener;

    public TableSelectionAdapter(JTable table, ITableSelectionListener listener) {
        this.table = table;
        this.tableModel = (ObjectReflectTableModel)this.table.getModel();
        this.listener = listener;
        ListSelectionModel slm = this.table.getSelectionModel();
        slm.addListSelectionListener(this);
        this.table.addMouseListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selectedRows;
        if (!e.getValueIsAdjusting() && (selectedRows = this.table.getSelectedRows()).length > 0) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            for (int i = 0; i < selectedRows.length; ++i) {
                Object obj = this.tableModel.getObject(selectedRows[i]);
                if (obj == null) continue;
                list.add(obj);
            }
            this.listener.rowSelectionChanged(list.toArray());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object value;
        if (e.getClickCount() == 2 && (value = this.tableModel.getObject(this.table.getSelectedRow())) != null) {
            this.listener.rowDoubleClicked(value);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

