/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import com.sun.media.imageio.stream.SegmentedImageInputStream;
import com.sun.media.imageio.stream.StreamSegment;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;
import org.dcm4che.data.DcmParser;
import org.dcm4che.dict.Tags;

public class ItemParser
implements StreamSegmentMapper {
    private static final Logger log = Logger.getLogger(ItemParser.class);
    private final ArrayList items = new ArrayList();
    private final DcmParser parser;
    private final ImageInputStream iis;
    private boolean lastItemSeen = false;

    public ItemParser(DcmParser parser) throws IOException {
        this.parser = parser;
        this.iis = parser.getImageInputStream();
        parser.parseHeader();
        this.iis.skipBytes(parser.getReadLength());
        this.next();
    }

    public int getNumberOfDataFragments() {
        while (!this.lastItemSeen) {
            this.next();
        }
        return this.items.size();
    }

    public Item getItem(int index) {
        while (this.items.size() <= index) {
            if (this.next() != null) continue;
            throw new IndexOutOfBoundsException("index:" + index + " >= size:" + this.items.size());
        }
        return (Item)this.items.get(index);
    }

    private Item next() {
        if (this.lastItemSeen) {
            return null;
        }
        try {
            if (!this.items.isEmpty()) {
                this.iis.seek(this.last().nextItemPos());
            }
            this.parser.parseHeader();
            if (log.isDebugEnabled()) {
                log.debug("Read " + Tags.toString(this.parser.getReadTag()) + " #" + this.parser.getReadLength());
            }
            if (this.parser.getReadTag() == -73728) {
                Item item = new Item(this.items.isEmpty() ? 0 : this.last().nextOffset(), this.iis.getStreamPosition(), this.parser.getReadLength());
                this.items.add(item);
                return item;
            }
        }
        catch (IOException e) {
            log.warn("i/o error reading next item:", e);
        }
        if (this.parser.getReadTag() != -73507 || this.parser.getReadLength() != 0) {
            log.warn("expected (FFFE,E0DD) #0 but read " + Tags.toString(this.parser.getReadTag()) + " #" + this.parser.getReadLength());
        }
        this.lastItemSeen = true;
        return null;
    }

    private Item last() {
        return (Item)this.items.get(this.items.size() - 1);
    }

    public StreamSegment getStreamSegment(long pos, int len) {
        StreamSegment retval = new StreamSegment();
        this.getStreamSegment(pos, len, retval);
        return retval;
    }

    public void getStreamSegment(long pos, int len, StreamSegment seg) {
        if (log.isDebugEnabled()) {
            log.debug("getStreamSegment(pos=" + pos + ", len=" + len + ")");
        }
        Item item = this.last();
        while ((long)item.nextOffset() <= pos) {
            item = this.next();
            if (item != null) continue;
            seg.setSegmentLength(-1);
            return;
        }
        int i = this.items.size() - 1;
        while ((long)item.offset > pos) {
            item = (Item)this.items.get(--i);
        }
        seg.setStartPos(item.startPos + pos - (long)item.offset);
        seg.setSegmentLength(Math.min((int)((long)(item.offset + item.length) - pos), len));
        if (log.isDebugEnabled()) {
            log.debug("return StreamSegment[start=" + seg.getStartPos() + ", len=" + seg.getSegmentLength() + "]");
        }
    }

    public long seekNextFrame(SegmentedImageInputStream siis) throws IOException {
        Item item = this.last();
        long pos = siis.getStreamPosition();
        int i = this.items.size() - 1;
        while ((long)item.offset >= pos) {
            item = (Item)this.items.get(--i);
        }
        siis.seek(item.nextOffset());
        this.iis.seek(item.nextItemPos());
        return item.nextOffset();
    }

    public void seekFooter() throws IOException {
        this.iis.seek(this.last().nextItemPos());
        this.parser.parseHeader();
    }

    public static final class Item {
        public final int offset;
        public final long startPos;
        public final int length;

        public Item(int offset, long startPos, int length) {
            this.offset = offset;
            this.startPos = startPos;
            this.length = length;
        }

        public final int nextOffset() {
            return this.offset + this.length;
        }

        public final long nextItemPos() {
            return this.startPos + (long)this.length;
        }

        public String toString() {
            return "Item[off=" + this.offset + ", pos=" + this.startPos + ", len=" + this.length + "]";
        }
    }
}

