/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.OrderList;
import open.dolphin.client.OrderListTransferable;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.InfoModelTransferable;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.log.LogWriter;

public class StampTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1205897976539749194L;
    private StampTree sourceTree;
    private StampTreeNode dragNode;
    private DataFlavor stampTreeNodeFlavor = LocalStampTreeNodeTransferable.localStampTreeNodeFlavor;
    private DataFlavor orderFlavor = OrderListTransferable.orderListFlavor;
    private DataFlavor stringFlavor = DataFlavor.stringFlavor;
    private DataFlavor infoModelFlavor = InfoModelTransferable.infoModelFlavor;

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.sourceTree = (StampTree)c;
        this.dragNode = (StampTreeNode)this.sourceTree.getLastSelectedPathComponent();
        return new LocalStampTreeNodeTransferable(this.dragNode);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    private void moveTo(DefaultTreeModel model, StampTree targetTree, StampTreeNode sourceNode, int index, StampTreeNode newParent) {
        try {
            model.removeNodeFromParent(sourceNode);
            model.insertNodeInto(sourceNode, newParent, index);
            Object[] path = model.getPathToRoot(sourceNode);
            targetTree.setSelectionPath(new TreePath(path));
        }
        catch (Exception e1) {
            LogWriter.error(this.getClass(), e1);
        }
    }

    private void moveToLast(DefaultTreeModel model, StampTree targetTree, StampTreeNode sourceNode, StampTreeNode newParent) {
        try {
            model.removeNodeFromParent(sourceNode);
            model.insertNodeInto(sourceNode, newParent, newParent.getChildCount());
            Object[] path = model.getPathToRoot(sourceNode);
            targetTree.setSelectionPath(new TreePath(path));
        }
        catch (Exception e1) {
            LogWriter.error(this.getClass(), e1);
        }
    }

    private boolean isInPath(DefaultTreeModel model, StampTreeNode sourceNode, StampTreeNode targetNode) {
        TreeNode[] parents;
        boolean result = false;
        for (TreeNode parent : parents = model.getPathToRoot(targetNode)) {
            if (parent != sourceNode) continue;
            result = true;
            Toolkit.getDefaultToolkit().beep();
            break;
        }
        return result;
    }

    private boolean dorpTo(DefaultTreeModel model, StampTree targetTree, StampTreeNode sourceNode, StampTreeNode targetNode, StampTreeNode newParent) {
        if (!this.isInPath(model, sourceNode, targetNode) && newParent != sourceNode) {
            if (targetNode.isLeaf()) {
                this.moveTo(model, targetTree, sourceNode, newParent.getIndex(targetNode), newParent);
            } else if (sourceNode != targetNode) {
                this.moveToLast(model, targetTree, sourceNode, targetNode);
            }
        }
        return true;
    }

    private boolean dorpToFixNode(DefaultTreeModel model, StampTree targetTree, StampTreeNode sourceNode, StampTreeNode targetNode, StampTreeNode newParent) {
        int index = newParent.getIndex(targetNode);
        if (index > 0) {
            if (index == newParent.getChildCount() - 1) {
                this.moveTo(model, targetTree, sourceNode, --index, newParent);
            } else {
                this.moveTo(model, targetTree, sourceNode, ++index, newParent);
            }
        }
        return true;
    }

    private boolean innerDragAndDrop(StampTree targetTree, StampTreeNode sourceNode, StampTreeNode targetNode, StampTreeNode newParent) {
        DefaultTreeModel model = (DefaultTreeModel)targetTree.getModel();
        if (targetNode != null && targetNode.isMoveable()) {
            if (sourceNode != null && sourceNode.isMoveable()) {
                return this.dorpTo(model, targetTree, sourceNode, targetNode, newParent);
            }
        } else {
            return this.dorpToFixNode(model, targetTree, sourceNode, targetNode, newParent);
        }
        return false;
    }

    private boolean importOrder(Transferable transferData, StampTreeNode selected, StampTree targetTree, String targetEntity) throws IOException, SQLException {
        boolean result = false;
        try {
            Object list = transferData.getTransferData(OrderListTransferable.orderListFlavor);
            if (list instanceof OrderList) {
                ModuleModel droppedStamp = ((OrderList)list).getOrderList()[0];
                if (droppedStamp.getModuleInfo().getEntity().equals(targetEntity)) {
                    return targetTree.addStamp(droppedStamp, selected);
                }
                if (targetEntity.equals("path")) {
                    if (selected == null) {
                        selected = (StampTreeNode)targetTree.getModel().getRoot();
                    }
                    result = targetTree.addStamp(droppedStamp, selected);
                } else {
                    result = targetTree.addStamp(droppedStamp, null);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            LogWriter.error(this.getClass(), e);
        }
        return result;
    }

    private boolean importString(Transferable transferData, StampTreeNode selected, StampTree targetTree, String targetEntity) throws IOException, SQLException {
        boolean result = false;
        try {
            String text = (String)transferData.getTransferData(DataFlavor.stringFlavor);
            result = targetEntity.equals("text") ? targetTree.addTextStamp(text, selected) : targetTree.addTextStamp(text, null);
        }
        catch (UnsupportedFlavorException e) {
            LogWriter.error(this.getClass(), e);
        }
        return result;
    }

    private boolean importinfoModel(Transferable transferData, StampTreeNode selected, StampTree targetTree, String targetEntity) throws UnsupportedFlavorException, IOException, SQLException {
        boolean result = false;
        try {
            RegisteredDiagnosisModel diagnosis = (RegisteredDiagnosisModel)transferData.getTransferData(InfoModelTransferable.infoModelFlavor);
            result = targetEntity.equals("diagnosis") ? targetTree.addDiagnosis(diagnosis, selected) : targetTree.addDiagnosis(diagnosis, null);
        }
        catch (UnsupportedFlavorException e) {
            LogWriter.error(this.getClass(), e);
        }
        return result;
    }

    @Override
    public boolean importData(JComponent targetNode, Transferable transferData) {
        if (this.canImport(targetNode, transferData.getTransferDataFlavors())) {
            try {
                StampTree target = (StampTree)targetNode;
                String targetEntity = target.getEntity();
                boolean result = false;
                StampTreeNode selected = (StampTreeNode)target.getLastSelectedPathComponent();
                StampTreeNode newParent = null;
                if (selected != null) {
                    newParent = (StampTreeNode)selected.getParent();
                }
                if (transferData.isDataFlavorSupported(this.stampTreeNodeFlavor) && selected != null) {
                    StampTreeNode dropNode = (StampTreeNode)transferData.getTransferData(this.stampTreeNodeFlavor);
                    result = this.innerDragAndDrop(target, dropNode, selected, newParent);
                } else if (transferData.isDataFlavorSupported(this.orderFlavor)) {
                    result = this.importOrder(transferData, selected, target, targetEntity);
                } else if (transferData.isDataFlavorSupported(this.stringFlavor)) {
                    result = this.importString(transferData, selected, target, targetEntity);
                } else if (transferData.isDataFlavorSupported(this.infoModelFlavor)) {
                    result = this.importinfoModel(transferData, selected, target, targetEntity);
                } else {
                    return false;
                }
                target.saveStampTree();
                return result;
            }
            catch (UnsupportedFlavorException e) {
                LogWriter.error(this.getClass(), e);
            }
            catch (Exception ioe) {
                LogWriter.error(this.getClass(), ioe);
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (this.stampTreeNodeFlavor.equals(flavor)) {
                return true;
            }
            if (this.orderFlavor.equals(flavor)) {
                return true;
            }
            if (this.stringFlavor.equals(flavor)) {
                return true;
            }
            if (!this.infoModelFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

